/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.monitor.run.factory.SelectMonitor;
import com.clustercontrol.snmptrap.bean.TrapCheckInfo;
import com.clustercontrol.snmptrap.model.MonitorTrapInfoEntity;
import com.clustercontrol.snmptrap.util.QueryUtil;

/**
 * SNMPTRAP監視情報を検索するクラス<BR>
 *
 * @version 4.0.0
 * @since 4.0.0
 */
public class SelectMonitorTrap extends SelectMonitor {

	private static Log m_log = LogFactory.getLog( SelectMonitorTrap.class );

	@Override
	protected TrapCheckInfo getTrapCheckInfo() throws MonitorNotFound {
		m_log.debug("getTrapCheckInfo() : start");

		MonitorTrapInfoEntity entity = QueryUtil.getMonitorTrapInfoPK(m_monitorId);

		if(m_log.isDebugEnabled()){
			m_log.debug("getTrapCheckInfo() : " +
					" MonitorId = " + entity.getMonitorId() +
					",CommunityName = " + entity.getCommunityName() +
					",CheckMode = " + entity.getCheckMode() +
					",CommunityCheck = " + entity.getCommunityCheck() +
					",CharsetConvert = " + entity.getCharsetConvert() +
					",CharsetName = " + entity.getCharsetName());
		}

		TrapCheckInfo trap = new TrapCheckInfo();
		trap.setMonitorId(m_monitorId);
		trap.setMonitorTypeId(m_monitorTypeId);
		trap.setCommunityName(entity.getCommunityName());
		trap.setCheckMode(entity.getCheckMode());
		trap.setCommunityCheck(entity.getCommunityCheck());
		trap.setCharsetConvert(entity.getCharsetConvert());
		trap.setCharsetName(entity.getCharsetName());

		m_log.debug("getTrapCheckInfo() : end");
		return trap;
	}
}
