/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.util;

import java.util.List;

import javax.persistence.EntityManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.snmptrap.model.MonitorTrapInfoEntity;
import com.clustercontrol.snmptrap.model.SnmpTrapMibMstEntity;
import com.clustercontrol.snmptrap.model.SnmpTrapMstEntity;
import com.clustercontrol.snmptrap.model.SnmpTrapMstEntityPK;

public class QueryUtil {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( QueryUtil.class );

	public static MonitorTrapInfoEntity getMonitorTrapInfoPK(String monitorId) throws MonitorNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		MonitorTrapInfoEntity entity = em.find(MonitorTrapInfoEntity.class, monitorId);
		if (entity == null) {
			MonitorNotFound e = new MonitorNotFound("MonitorTrapInfoEntity.findByPrimaryKey, "
					+ "monitorId = " + monitorId);
			m_log.info("getMonitorTrapInfoPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static SnmpTrapMibMstEntity getSnmpTrapMibMstPK(String mib) throws MonitorNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		SnmpTrapMibMstEntity entity = em.find(SnmpTrapMibMstEntity.class, mib);
		if (entity == null) {
			MonitorNotFound e = new MonitorNotFound("SnmpTrapMibMstEntity.findByPrimaryKey, "
					+ "mib = " + mib);
			m_log.info("getSnmpTrapMibMstPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static List<SnmpTrapMibMstEntity> getAllSnmpTrapMibMst() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<SnmpTrapMibMstEntity> list
		= em.createNamedQuery("SnmpTrapMibMstEntity.findAll", SnmpTrapMibMstEntity.class)
		.getResultList();
		return list;
	}

	public static SnmpTrapMstEntity getSnmpTrapMstPK(SnmpTrapMstEntityPK pk) throws MonitorNotFound {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		SnmpTrapMstEntity entity = em.find(SnmpTrapMstEntity.class, pk);
		if (entity == null) {
			MonitorNotFound e = new MonitorNotFound("SnmpTrapMstEntity.findByPrimaryKey, "
					+ pk.toString());
			m_log.info("getSnmpTrapMstPK() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return entity;
	}

	public static SnmpTrapMstEntity getSnmpTrapMstPK(String mib,
			String trapOid,
			Integer genericId,
			Integer specificId) throws MonitorNotFound {
		return getSnmpTrapMstPK(new SnmpTrapMstEntityPK(mib, trapOid, genericId, specificId));
	}

	public static List<SnmpTrapMstEntity> getAllSnmpTrapMst() {
		EntityManager em = new JpaTransactionManager().getEntityManager();
		List<SnmpTrapMstEntity> list
		= em.createNamedQuery("SnmpTrapMstEntity.findAll", SnmpTrapMstEntity.class)
		.getResultList();
		return list;
	}
}
