/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Export;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CloudStorageBackupManager;
import com.clustercontrol.cloud.presenter.ICloudStorageBackup;
import com.clustercontrol.cloud.presenter.InternalComponent;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudStorageBackup
extends InternalComponent<CloudStorageBackupManager, com.clustercontrol.ws.cloud.CloudStorageBackup>
implements ICloudStorageBackup {
    private String accountResourceId;
    private String cloudUserId;
    private String description;
    private String storageBackupId;
    private String snapshotName;
    private Long regDate;
    private String regUser;
    private String region;
    private String restoreStatus;
    private String storageId;
    private String cloudTypeId;
    private ICloudStorageBackup.BackupedData backupedData;

    public CloudStorageBackup(CloudStorageBackupManager container) {
        super(container);
    }

    @Override
    @Export
    public String getStorageId() {
        return this.storageId;
    }

    @Import
    public void setStorageId(String storageId) {
        this.internalSet("storageId", ICloudStorageBackup.p2.storageId, storageId);
    }

    @Override
    @Export
    public String getRegion() {
        return this.region;
    }

    @Import
    public void setRegion(String region) {
        this.internalSet("region", ICloudStorageBackup.p2.region, region);
    }

    @Override
    @Export
    public Long getRegDate() {
        return this.regDate;
    }

    @Import
    public void setRegDate(Long regDate) {
        this.internalSet("regDate", ICloudStorageBackup.p2.regDate, regDate);
    }

    @Override
    @Export
    public String getRegUser() {
        return this.regUser;
    }

    @Import
    public void setRegUser(String regUser) {
        this.internalSet("regUser", ICloudStorageBackup.p2.regUser, regUser);
    }

    @Override
    @Export
    public String getCloudUserId() {
        return this.cloudUserId;
    }

    @Import
    public void setCloudUserId(String cloudUserId) {
        this.internalSet("cloudUserId", ICloudStorageBackup.p2.cloudUserId, cloudUserId);
    }

    @Override
    @Export
    public String getRestoreStatus() {
        return this.restoreStatus;
    }

    @Import
    public void setRestoreStatus(String restoreStatus) {
        this.internalSet("restoreStatus", ICloudStorageBackup.p2.restoreStatus, restoreStatus);
    }

    @Override
    @Export
    public String getSnapshotName() {
        return this.snapshotName;
    }

    @Import
    public void setSnapshotName(String snapshotName) {
        this.internalSet("snapshotName", ICloudStorageBackup.p2.snapshotName, snapshotName);
    }

    @Override
    @Export
    public String getStorageBackupId() {
        return this.storageBackupId;
    }

    @Import
    public void setStorageBackupId(String storageBackupId) {
        this.internalSet("storageBackupId", ICloudStorageBackup.p2.storageBackupId, storageBackupId);
    }

    @Override
    @Export
    public String getDescription() {
        return this.description;
    }

    @Import
    public void setDescription(String description) {
        this.internalSet("description", ICloudStorageBackup.p2.description, description);
    }

    @Override
    @Export
    public String getAccountResourceId() {
        return this.accountResourceId;
    }

    @Import
    public void setAccountResourceId(String accountResourceId) {
        this.internalSet("accountResourceId", ICloudStorageBackup.p2.accountResourceId, accountResourceId);
    }

    @Override
    @Export
    public String getCloudTypeId() {
        return this.cloudTypeId;
    }

    @Import
    public void setCloudTypeId(String cloudTypeId) {
        this.internalSet("cloudTypeId", ICloudStorageBackup.p2.cloudTypeId, cloudTypeId);
    }

    @Override
    public ICloudStorageBackup.BackupedData getBackupedData() {
        return this.backupedData;
    }

    public void setBackupedData(ICloudStorageBackup.BackupedData backupedData) {
        this.internalSet("backupedData", ICloudStorageBackup.p2.backupedData, backupedData);
    }

    @Override
    public CloudStorageBackupManager getCloudStorageBackupManager() {
        return (CloudStorageBackupManager)this.getContainer();
    }

    @Override
    public boolean equalValues(com.clustercontrol.ws.cloud.CloudStorageBackup source) {
        return this.storageId.equals(source.getStorageBackupId());
    }

    public static CloudStorageBackup createCloudStorageBackup(CloudStorageBackupManager cloudStorageManager, com.clustercontrol.ws.cloud.CloudStorageBackup source) {
        CloudStorageBackup cloudStorage = new CloudStorageBackup(cloudStorageManager);
        cloudStorage.overwrite(source);
        return cloudStorage;
    }

    @Override
    public com.clustercontrol.ws.cloud.CloudStorageBackup getSource() throws CloudModelException {
        try {
            return this.getEndpoint().getStorageBackup(this.getCloudStorageBackupManager().getRegion().getAccountResource().getActiveUser().getRoleId(), this.region, this.storageBackupId);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected void overwrite(com.clustercontrol.ws.cloud.CloudStorageBackup source) {
        ControlUtil.importObject(this, source);
        if (source.getBackupedData() != null) {
            ControlUtil.importObject(this, source.getBackupedData());
        }
        if (source.getRestoreStatus() != null) {
            this.setRestoreStatus(source.getRestoreStatus().value());
        }
        this.setCloudTypeId(this.internalGetCloudTypeId());
        this.setBackupedData(new ICloudStorageBackup.BackupedData(source.getBackupedData().getFlavor(), source.getBackupedData().getZone(), source.getBackupedData().getSize(), source.getBackupedData().getStorageDetail()));
    }

    private CloudEndpoint getEndpoint() {
        return this.getCloudStorageBackupManager().getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
    }

    private String internalGetCloudTypeId() {
        String cloudServiceId = this.getCloudStorageBackupManager().getCloudComputeService().getRegion().getAccountResource().getCloudServiceId();
        String cloudTypeId = this.getCloudStorageBackupManager().getCloudComputeService().getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getCloudServiceManager().getCloudService(cloudServiceId).getCloudTypeId();
        return cloudTypeId;
    }
}

