/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.AccountResource;
import com.clustercontrol.cloud.presenter.CloudComputeService;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CloudStorage;
import com.clustercontrol.cloud.presenter.CreateStorageRequest;
import com.clustercontrol.cloud.presenter.ICloudStorageManager;
import com.clustercontrol.cloud.presenter.InternalContainer;
import com.clustercontrol.cloud.presenter.RestoreCloudStorageRequest;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import java.util.List;

public class CloudStorageManager
extends InternalContainer<CloudStorage, com.clustercontrol.ws.cloud.CloudStorage>
implements ICloudStorageManager {
    private CloudComputeService cloudComputeService;

    public CloudStorageManager(CloudComputeService cloudComputeService) {
        this.cloudComputeService = cloudComputeService;
    }

    @Override
    public AccountResource.Region getRegion() {
        return this.cloudComputeService.getRegion();
    }

    private CloudStorage internalGetCloudStorage(String cloudStorageId) {
        for (CloudStorage cloudStorage : this.getComponents()) {
            if (!cloudStorage.getStorageId().equals(cloudStorageId)) continue;
            return cloudStorage;
        }
        return null;
    }

    public CloudStorage[] getCloudStorages() {
        return this.getComponents().toArray(new CloudStorage[0]);
    }

    @Override
    public CloudStorage createCloudStorage(CreateStorageRequest createStorageRequest) {
        com.clustercontrol.ws.cloud.CreateStorageRequest wsCreateStorageRequest = new com.clustercontrol.ws.cloud.CreateStorageRequest();
        CreateStorageRequest request = new CreateStorageRequest();
        ControlUtil.importObject(request, createStorageRequest);
        ControlUtil.exportObject(request, wsCreateStorageRequest);
        try {
            com.clustercontrol.ws.cloud.CloudStorage reWsCloudStorage = this.getEndpoint().addStorage(this.getRoleId(), this.getRegion().getRegion(), wsCreateStorageRequest);
            CloudStorage cloudStorage = this.createComponent(reWsCloudStorage);
            this.getComponents().add(cloudStorage);
            this.fireElementAdded(ICloudStorageManager.p2.cloudStorages, cloudStorage);
            return cloudStorage;
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void removeCloudStorage(String StorageId) {
        try {
            this.getEndpoint().removeStorage(this.getRoleId(), this.getRegion().getRegion(), StorageId);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
        CloudStorage cloudStorage = this.internalGetCloudStorage(StorageId);
        this.getComponents().remove(cloudStorage);
        this.fireElementRemoved(ICloudStorageManager.p2.cloudStorages, cloudStorage);
    }

    @Override
    public CloudStorage restoreCloudStorage(RestoreCloudStorageRequest restoreCloudStorageRequest) {
        return null;
    }

    @Override
    protected List<com.clustercontrol.ws.cloud.CloudStorage> getSources() throws CloudModelException {
        try {
            return this.getEndpoint().getStoragesByRegion(this.getRoleId(), this.getRegion().getRegion());
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected CloudStorage createComponent(com.clustercontrol.ws.cloud.CloudStorage source) throws CloudModelException {
        return CloudStorage.createCloudStorage(this, source);
    }

    @Override
    protected void fireComponentAdded(CloudStorage addedValue) {
        this.fireElementAdded(ICloudStorageManager.p2.cloudStorages, addedValue);
    }

    @Override
    protected void fireComponentRemoved(CloudStorage removedValue) {
        this.fireElementRemoved(ICloudStorageManager.p2.cloudStorages, removedValue);
    }

    private String getRoleId() {
        return this.getRegion().getAccountResource().getActiveUser().getRoleId();
    }

    @Override
    public CloudComputeService getCloudComputeService() {
        return this.cloudComputeService;
    }

    public CloudEndpoint getEndpoint() {
        return this.getCloudComputeService().getEndpoint();
    }
}

