/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.CloudUser;
import com.clustercontrol.cloud.presenter.ModifyCloudUserRequest;
import com.clustercontrol.cloud.ui.dialogs.CreateCloudUserDialog;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class EditCloudUserAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.EditCloudUserAction";
    private MessageManager messages = MessageManager.getInstance("messages");
    private String msgEditCloudUserConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.cloud_user", "word.modify"});
    private String msgEditCloudUserResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.cloud_user", "word.modify"});

    @Override
    protected void invoke(IAction action) throws InvocationException {
        CreateCloudUserDialog dialog = new CreateCloudUserDialog(this.viewPart.getSite().getShell());
        IStructuredSelection selection = (IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection();
        final CloudUser cloudUser = (CloudUser)selection.getFirstElement();
        dialog.setBehavior(new CreateCloudUserDialog.DialogBehavior(){

            @Override
            public void setupCloudUserId(Text cloudUserId) {
                if (cloudUser != null && cloudUser.getCloudUserId() != null) {
                    cloudUserId.setText(cloudUser.getCloudUserId());
                }
                cloudUserId.setEditable(false);
            }

            @Override
            public void setupCloudUserName(Text cloudUserName) {
                if (cloudUser != null && cloudUser.getCloudUserName() != null) {
                    cloudUserName.setText(cloudUser.getCloudUserName());
                }
            }

            @Override
            public void setupDescription(Text description) {
                if (cloudUser != null && cloudUser.getDescription() != null) {
                    description.setText(cloudUser.getDescription());
                }
            }

            @Override
            public void setupAccessKey(Text accessKey) {
                if (cloudUser != null && cloudUser.getAccessKey() != null) {
                    accessKey.setText(cloudUser.getAccessKey());
                }
            }

            @Override
            public void setupSecretKey(Text secretKey) {
                if (cloudUser != null && cloudUser.getSecretKey() != null) {
                    secretKey.setText(cloudUser.getSecretKey());
                }
            }

            @Override
            public void setupAssignRoleId(Combo assignRoleId) {
                assignRoleId.add(cloudUser.getRoleId());
                assignRoleId.select(assignRoleId.indexOf(cloudUser.getRoleId()));
                assignRoleId.setEnabled(false);
            }

            @Override
            public void setupAccountResourceId(Combo accountResourceId) {
                super.setupAccountResourceId(accountResourceId);
                if (cloudUser.getAccountResourceId() != null && accountResourceId.indexOf(cloudUser.getAccountResourceId()) != -1) {
                    accountResourceId.select(accountResourceId.indexOf(cloudUser.getAccountResourceId()));
                }
                accountResourceId.setEnabled(false);
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgEditCloudUserConfirm)) {
                CreateCloudUserDialog.DialogOutput output = dialog.getOutput();
                ModifyCloudUserRequest request = new ModifyCloudUserRequest();
                ControlUtil.importObject(request, output);
                cloudUser.modifyCloudUser(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgEditCloudUserResult);
            } else {
                return;
            }
        }
    }
}

