/*

Copyright (C) 2009 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */
package com.clustercontrol.accesscontrol.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.bean.FunctionConstant;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant.SystemPrivilegeMode;
import com.clustercontrol.util.Messages;

/**
 * システム権限の表示文字列とシステム権限テーブル値を保持するユーティリティクラスです。
 * 
 * @version 4.0.0
 */
public class SystemPrivilegePropertyUtil {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog(SystemPrivilegePropertyUtil.class);

	/** システム権限マップ（システム権限、表示文字列） */
	private static Map<String, String> m_systemPrivilegeMap = new HashMap<String, String>();

	private static void createSystemPrivilegeMap(){
		Locale locale = Locale.getDefault();
		if (m_systemPrivilegeMap == null || m_systemPrivilegeMap.size() == 0) {
			//リポジトリ - 参照
			m_systemPrivilegeMap.put(FunctionConstant.REPOSITORY + SystemPrivilegeMode.READ.name(), Messages.getString("repository.read", locale));
			//リポジトリ - 更新
			m_systemPrivilegeMap.put(FunctionConstant.REPOSITORY + SystemPrivilegeMode.WRITE.name(), Messages.getString("repository.write", locale));
			//リポジトリ - 作成
			m_systemPrivilegeMap.put(FunctionConstant.REPOSITORY + SystemPrivilegeMode.ADD.name(), Messages.getString("repository.create", locale));
			//リポジトリ - 実行
			m_systemPrivilegeMap.put(FunctionConstant.REPOSITORY + SystemPrivilegeMode.EXEC.name(), Messages.getString("repository.execute", locale));
			
			//アカウント - 参照
			m_systemPrivilegeMap.put(FunctionConstant.ACCESSCONTROL + SystemPrivilegeMode.READ.name(), Messages.getString("accesscontrol.read", locale));
			//アカウント - 更新
			m_systemPrivilegeMap.put(FunctionConstant.ACCESSCONTROL + SystemPrivilegeMode.WRITE.name(), Messages.getString("accesscontrol.write", locale));
			//アカウント - 作成
			m_systemPrivilegeMap.put(FunctionConstant.ACCESSCONTROL + SystemPrivilegeMode.ADD.name(), Messages.getString("accesscontrol.create", locale));
			
			//監視 - 参照
			m_systemPrivilegeMap.put(FunctionConstant.MONITOR_RESULT + SystemPrivilegeMode.READ.name(), Messages.getString("monitor.result.read", locale));
			//監視 - 更新
			m_systemPrivilegeMap.put(FunctionConstant.MONITOR_RESULT + SystemPrivilegeMode.WRITE.name(), Messages.getString("monitor.result.write", locale));
			
			//監視設定 - 参照
			m_systemPrivilegeMap.put(FunctionConstant.MONITOR_SETTING + SystemPrivilegeMode.READ.name(), Messages.getString("monitor.setting.read", locale));
			//監視設定 - 更新
			m_systemPrivilegeMap.put(FunctionConstant.MONITOR_SETTING + SystemPrivilegeMode.WRITE.name(), Messages.getString("monitor.setting.write", locale));
			//監視設定 - 作成
			m_systemPrivilegeMap.put(FunctionConstant.MONITOR_SETTING + SystemPrivilegeMode.ADD.name(), Messages.getString("monitor.setting.create", locale));
			
			//ジョブ管理 - 参照
			m_systemPrivilegeMap.put(FunctionConstant.JOBMANAGEMENT + SystemPrivilegeMode.READ.name(), Messages.getString("jobmanagement.read", locale));
			//ジョブ - 更新
			m_systemPrivilegeMap.put(FunctionConstant.JOBMANAGEMENT + SystemPrivilegeMode.WRITE.name(), Messages.getString("jobmanagement.write", locale));
			//ジョブ - 作成
			m_systemPrivilegeMap.put(FunctionConstant.JOBMANAGEMENT + SystemPrivilegeMode.ADD.name(), Messages.getString("jobmanagement.create", locale));
			//ジョブ - 実行
			m_systemPrivilegeMap.put(FunctionConstant.JOBMANAGEMENT + SystemPrivilegeMode.EXEC.name(), Messages.getString("jobmanagement.execute", locale));
			
			//性能管理 - 参照
			m_systemPrivilegeMap.put(FunctionConstant.PERFORMANCE + SystemPrivilegeMode.READ.name(), Messages.getString("performance.read", locale));
			//性能管理 - 実行
//			m_systemPrivilegeMap.put(FunctionConstant.PERFORMANCE + SystemPrivilegeMode.EXEC.name(), Messages.getString("performance.execute", locale));
			
			//カレンダ - 参照
			m_systemPrivilegeMap.put(FunctionConstant.CALENDAR + SystemPrivilegeMode.READ.name(), Messages.getString("calendar.read", locale));
			//カレンダ - 更新
			m_systemPrivilegeMap.put(FunctionConstant.CALENDAR + SystemPrivilegeMode.WRITE.name(), Messages.getString("calendar.write", locale));
			//カレンダ - 作成
			m_systemPrivilegeMap.put(FunctionConstant.CALENDAR + SystemPrivilegeMode.ADD.name(), Messages.getString("calendar.create", locale));
			
			//通知 - 参照
			m_systemPrivilegeMap.put(FunctionConstant.NOTIFY + SystemPrivilegeMode.READ.name(), Messages.getString("notify.id.read", locale));
			//通知 - 更新
			m_systemPrivilegeMap.put(FunctionConstant.NOTIFY + SystemPrivilegeMode.WRITE.name(), Messages.getString("notify.id.write", locale));
			//通知 - 作成
			m_systemPrivilegeMap.put(FunctionConstant.NOTIFY + SystemPrivilegeMode.ADD.name(), Messages.getString("notify.id.create", locale));
			
			//履歴情報削除 - 参照
			m_systemPrivilegeMap.put(FunctionConstant.MAINTENANCE + SystemPrivilegeMode.READ.name(), Messages.getString("maintenance.read", locale));
			//履歴情報削除 - 更新
			m_systemPrivilegeMap.put(FunctionConstant.MAINTENANCE + SystemPrivilegeMode.WRITE.name(), Messages.getString("maintenance.write", locale));
			//履歴情報削除 - 作成
			m_systemPrivilegeMap.put(FunctionConstant.MAINTENANCE + SystemPrivilegeMode.ADD.name(), Messages.getString("maintenance.create", locale));
			
			//仮想化管理 - 参照
			m_systemPrivilegeMap.put(FunctionConstant.VMMANAGEMENT + SystemPrivilegeMode.READ.name(), Messages.getString("vm.management.read", locale));
			//仮想化管理 - 更新
			m_systemPrivilegeMap.put(FunctionConstant.VMMANAGEMENT + SystemPrivilegeMode.WRITE.name(), Messages.getString("vm.management.write", locale));
			//仮想化管理 - 作成
			m_systemPrivilegeMap.put(FunctionConstant.VMMANAGEMENT + SystemPrivilegeMode.ADD.name(), Messages.getString("vm.management.create", locale));
			//仮想化管理 - 実行
			m_systemPrivilegeMap.put(FunctionConstant.VMMANAGEMENT + SystemPrivilegeMode.EXEC.name(), Messages.getString("vm.management.execute", locale));
			
			//クラウド管理 - 参照
			m_systemPrivilegeMap.put(FunctionConstant.CLOUDMANAGEMENT + SystemPrivilegeMode.READ.name(), Messages.getString("cloud.management.read", locale));
			//クラウド管理 - 更新
			m_systemPrivilegeMap.put(FunctionConstant.CLOUDMANAGEMENT + SystemPrivilegeMode.WRITE.name(), Messages.getString("cloud.management.write", locale));
			//クラウド管理 - 作成
			m_systemPrivilegeMap.put(FunctionConstant.CLOUDMANAGEMENT + SystemPrivilegeMode.ADD.name(), Messages.getString("cloud.management.create", locale));
			//クラウド管理 - 実行
			m_systemPrivilegeMap.put(FunctionConstant.CLOUDMANAGEMENT + SystemPrivilegeMode.EXEC.name(), Messages.getString("cloud.management.execute", locale));
			
			//一括制御 - 参照
			m_systemPrivilegeMap.put(FunctionConstant.COLLECTIVERUN + SystemPrivilegeMode.READ.name(), Messages.getString("collectiverun.read", locale));
			//一括制御 - 更新
			m_systemPrivilegeMap.put(FunctionConstant.COLLECTIVERUN + SystemPrivilegeMode.WRITE.name(), Messages.getString("collectiverun.write", locale));
			//一括制御 - 作成
			m_systemPrivilegeMap.put(FunctionConstant.COLLECTIVERUN + SystemPrivilegeMode.ADD.name(), Messages.getString("collectiverun.create", locale));
			//一括制御 - 実行
			m_systemPrivilegeMap.put(FunctionConstant.COLLECTIVERUN + SystemPrivilegeMode.EXEC.name(), Messages.getString("collectiverun.execute", locale));
		}

		return;
	}

	public static List<String> getValueList() {
		createSystemPrivilegeMap();
		List<String> valueList = new ArrayList<String>();
		for (Map.Entry<String, String> systemPrivilege : m_systemPrivilegeMap.entrySet()) {
			valueList.add(systemPrivilege.getValue());
		}
		return valueList;
	}


	public static List<String> getKeyList() {
		createSystemPrivilegeMap();
		List<String> valueList = new ArrayList<String>();
		for (Map.Entry<String, String> systemPrivilege : m_systemPrivilegeMap.entrySet()) {
			valueList.add(systemPrivilege.getKey());
		}
		return valueList;
	}

	public static Map<String, String> getMap() {
		createSystemPrivilegeMap();
		return m_systemPrivilegeMap;
	}

	public static String getValue(String systemFunction, String systemPrivilege){
		createSystemPrivilegeMap();
		return m_systemPrivilegeMap.get(systemFunction + systemPrivilege);
	}

	public static String getKey(String value){
		String key = "";
		createSystemPrivilegeMap();
		for (Map.Entry<String, String> systemPrivilege : m_systemPrivilegeMap.entrySet()) {
			if (systemPrivilege.getValue().equals(value)) {
				key = systemPrivilege.getKey();
				break;
			}
		}
		return key;
	}
}
