package com.clustercontrol.jobmanagement.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.bean.HistoryFilterPropertyConstant;
import com.clustercontrol.jobmanagement.bean.JobOperationConstant;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.jobmanagement.bean.PlanFilterPropertyConstant;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.jobmanagement.HinemosUnknown_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobEndStatusInfo;
import com.clustercontrol.ws.jobmanagement.JobHistoryFilter;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobMasterNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.JobNotificationsInfo;
import com.clustercontrol.ws.jobmanagement.JobOperationInfo;
import com.clustercontrol.ws.jobmanagement.JobParameterInfo;
import com.clustercontrol.ws.jobmanagement.JobPlanFilter;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.NotifyNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.UserNotFound_Exception;

public class JobPropertyUtil {
	// ログ
	private static Log m_log = LogFactory.getLog( JobPropertyUtil.class );

	public static JobOperationInfo property2jobOperation (Property property) {
		JobOperationInfo info = new JobOperationInfo();

		//セッションID取得
		ArrayList values = PropertyUtil.getPropertyValue(property, JobOperationConstant.SESSION);
		if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0)
			info.setSessionId((String)values.get(0));

		//ジョブユニットID取得
		values = PropertyUtil.getPropertyValue(property, JobOperationConstant.JOB_UNIT);
		if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0)
			info.setJobunitId((String)values.get(0));

		//ジョブID取得
		values = PropertyUtil.getPropertyValue(property, JobOperationConstant.JOB);
		if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0)
			info.setJobId((String)values.get(0));

		//ファシリティID取得
		values = PropertyUtil.getPropertyValue(property, JobOperationConstant.FACILITY);
		if(values.size() > 0 && values.get(0) instanceof String && ((String)values.get(0)).length() > 0)
			info.setFacilityId((String)values.get(0));

		//制御取得
		values = PropertyUtil.getPropertyValue(property, JobOperationConstant.CONTROL);
		Integer control = null;
		if(values.get(0) instanceof String){
			String controlString = (String)values.get(0);
			control = Integer.valueOf(OperationConstant.stringToType(controlString));
			info.setControl(control);
		}

		//終了状態取得
		values = PropertyUtil.getPropertyValue(property, JobOperationConstant.END_STATUS);
		if(values.size() > 0 && values.get(0) instanceof Integer)
			info.setEndStatus((Integer)values.get(0));

		//終了値取得
		values = PropertyUtil.getPropertyValue(property, JobOperationConstant.END_VALUE);
		if(values.size() > 0 && values.get(0) instanceof Integer)
			info.setEndValue((Integer)values.get(0));

		// #2360における4.1.0のHinemosマネージャとの互換性のため、停止[スキップ]の場合は、デフォルト値(終了状態:異常、終了値:0)を入れる
		// 4.1.1以降のHinemosマネージャではこの値はマネージャ側で破棄される
		if (control == OperationConstant.TYPE_STOP_SKIP) {
			info.setEndStatus(EndStatusConstant.TYPE_ABNORMAL);
			info.setEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
		}

		return info;
	}

	public static JobHistoryFilter property2jobHistoryFilter (Property property) {
		JobHistoryFilter filter = new JobHistoryFilter();
		ArrayList values = null;

		//開始・再実行日時（自）取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.START_FROM_DATE);
		if(values.get(0) != null && values.get(0) instanceof Date){
			filter.setStartFromDate(((Date)values.get(0)).getTime());
		}
		//開始・再実行日時（至）取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.START_TO_DATE);
		if(values.get(0) != null && values.get(0) instanceof Date){
			filter.setStartToDate(((Date)values.get(0)).getTime());
		}
		//終了・中断日時（自）取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.END_FROM_DATE);
		if(values.get(0) != null && values.get(0) instanceof Date){
			filter.setEndFromDate(((Date)values.get(0)).getTime());
		}
		//終了・中断日時（至）取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.END_TO_DATE);
		if(values.get(0) != null && values.get(0) instanceof Date){
			filter.setEndToDate(((Date)values.get(0)).getTime());
		}

		//ジョブID取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.JOB_ID);
		if(values.get(0) instanceof JobTreeItem){
			filter.setJobId(((JobTreeItem)values.get(0)).getData().getId());
		}
		else if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0){
			filter.setJobId((String)values.get(0));
		}

		//状態取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.STATUS);
		Integer status = null;
		if(values.get(0) instanceof String){
			String statusString = (String)values.get(0);
			status = Integer.valueOf(StatusConstant.stringToType(statusString));
			filter.setStatus(status);
		}

		//実行契機種別取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.TRIGGER_TYPE);
		Integer triggerType = null;
		if(values.get(0) instanceof String){
			String triggerTypeString = (String)values.get(0);
			triggerType = Integer.valueOf(JobTriggerTypeConstant.stringToType(triggerTypeString));
			filter.setTriggerType(triggerType);
		}

		//実行契機情報取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.TRIGGER_INFO);
		String triggerInfo = null;
		if(!"".equals(values.get(0))) {
			triggerInfo = (String) values.get(0);
			filter.setTriggerInfo(triggerInfo);
		}
		
		//オーナーロールID
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.OWNER_ROLE_ID);
		String ownerRoleId = null;
		if(!"".equals(values.get(0))) {
			ownerRoleId = (String) values.get(0);
			filter.setOwnerRoleId(ownerRoleId);
		}
		return filter;
	}
	public static JobPlanFilter property2jobPlanFilter (Property property) {
		JobPlanFilter filter = new JobPlanFilter();
		ArrayList values = null;

		//開始取得
		values = PropertyUtil.getPropertyValue(property, PlanFilterPropertyConstant.FROM_DATE);
		m_log.trace("JobPlanFilter fromDate :");
		if(values.get(0) != null && values.get(0) instanceof Date){
			m_log.trace(" " + ((Date)values.get(0)).getTime());
			filter.setFromDate(((Date)values.get(0)).getTime());
		}
		//終了取得
		values = PropertyUtil.getPropertyValue(property, PlanFilterPropertyConstant.TO_DATE);
		m_log.trace("JobPlanFilter toDate :");
		if(values.get(0) != null && values.get(0) instanceof Date){
			m_log.trace(" " + ((Date)values.get(0)).getTime());
			filter.setToDate(((Date)values.get(0)).getTime());
		}
		//実行契機ID
		values = PropertyUtil.getPropertyValue(property, PlanFilterPropertyConstant.SCHEDULE_ID);
		if(values.get(0) != null){
			m_log.trace(" " + ((String)values.get(0)));
			filter.setJobKickId((String)values.get(0));
		}
		return filter;
	}

	/**
	 * ジョブツリーを全てFullにする。
	 * 負荷が高いので取り扱い注意。
	 * @param jobTreeItem
	 */
	public static void setJobFullTree (JobTreeItem jobTreeItem) {
		setJobFull(jobTreeItem.getData());
		List<JobTreeItem> children = jobTreeItem.getChildren();
		if (children == null) {
			return;
		}
		for (JobTreeItem child : children) {
			setJobFullTree(child);
		}
	}

	/**
	 * マネージャへアクセスするため、むやみに呼ばないこと。
	 * @param jobInfo
	 */
	public static void setJobFull (JobInfo jobInfo) {
		if (jobInfo.isPropertyFull()) {
			return;
		}
		if (jobInfo.getId() == null || "".equals(jobInfo.getId())) {
			return;
		}

		JobInfo ret = null;
		try {
			ret = JobEndpointWrapper.getJobFull(jobInfo);
		} catch (JobMasterNotFound_Exception e) {
			m_log.warn("setJobFull(), " + e.getMessage(), e);
			// 新ジョブの場合は、必ず通る。
			return;
		} catch (NotifyNotFound_Exception e) {
			m_log.warn("setJobFull() getJobFull, " + e.getMessage(), e);
			return;
		} catch (UserNotFound_Exception e) {
			m_log.warn("setJobFull() getJobFull, " + e.getMessage(), e);
			return;
		} catch (HinemosUnknown_Exception e) {
			m_log.warn("setJobFull() getJobFull, " + e.getMessage(), e);
			return;
		} catch (InvalidRole_Exception e) {
			m_log.warn("setJobFull() getJobFull, " + e.getMessage(), e);
			return;
		} catch (Exception e) {
			//TODO:メッセージを入れる必要があるか検討
			m_log.warn("setJobFull() getJobFull, " + e.getMessage(), e);
		}

		jobInfo.setCommand(ret.getCommand());
		//		jobInfo.seto
		jobInfo.setCreateTime(ret.getCreateTime());
		jobInfo.setCreateUser(ret.getCreateUser());
		jobInfo.setDescription(ret.getDescription());
		jobInfo.setOwnerRoleId(ret.getOwnerRoleId());
		List<JobEndStatusInfo> jobEndStatusInfoList = jobInfo.getEndStatus();
		jobEndStatusInfoList.clear();
		if (ret.getEndStatus() != null) {
			jobEndStatusInfoList.addAll(ret.getEndStatus());
		}
		jobInfo.setFile(ret.getFile());
		// jobInfo.setId(ret.getId());
		// jobInfo.setJobunitId(ret.getJobunitId());
		// jobInfo.setName(ret.getName());
		List<JobNotificationsInfo> jobNotificationsInfoList = jobInfo.getNotifications();
		jobNotificationsInfoList.clear();
		if (ret.getNotifications() != null) {
			jobNotificationsInfoList.addAll(ret.getNotifications());
		}
		List<JobParameterInfo> jobParameterInfoList = jobInfo.getParam();
		jobParameterInfoList.clear();
		if (ret.getParam() != null) {
			jobParameterInfoList.addAll(ret.getParam());
		}
		jobInfo.setPropertyFull(true);
		jobInfo.setType(ret.getType());
		jobInfo.setUpdateTime(ret.getUpdateTime());
		jobInfo.setUpdateUser(ret.getUpdateUser());
		jobInfo.setWaitRule(ret.getWaitRule());

		//参照ジョブ
		if(ret.getReferJobUnitId() != null){
			jobInfo.setReferJobUnitId(ret.getReferJobUnitId());
		}
		if(ret.getReferJobId() != null){
			jobInfo.setReferJobId(ret.getReferJobId());
		}
	}
}
