package com.clustercontrol.monitor.util;

import java.util.List;

import javax.xml.ws.WebServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.EndpointManager.EndpointSetting;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidSetting_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.JdbcDriverInfo;
import com.clustercontrol.ws.monitor.MonitorDuplicate_Exception;
import com.clustercontrol.ws.monitor.MonitorFilterInfo;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.MonitorSettingEndpoint;

/**
 * Hinemosマネージャとの通信をするクラス。 HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class MonitorSettingEndpointWrapper {

	// ログ
	private static Log m_log = LogFactory.getLog( MonitorSettingEndpointWrapper.class );

	public static List<MonitorInfo> getMonitorList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getMonitorList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getMonitorList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getMonitorListByCondition(MonitorFilterInfo condition)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getMonitorListByCondition(condition);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getMonitorListByCondition(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean addMonitor(MonitorInfo monitorInfo)
			throws HinemosUnknown_Exception,
			InvalidRole_Exception, InvalidUserPass_Exception,
			MonitorDuplicate_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager
				.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting
						.getEndpoint();
				return endpoint.addMonitor(monitorInfo);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("addMonitor(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean modifyMonitor(MonitorInfo monitorInfo)
			throws HinemosUnknown_Exception,
			InvalidRole_Exception, InvalidUserPass_Exception,
			MonitorNotFound_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager
				.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting
						.getEndpoint();
				return endpoint.modifyMonitor(monitorInfo);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyMonitor(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean deleteMonitor(String monitorId, String monitorTypeId)
			throws HinemosUnknown_Exception,
			InvalidRole_Exception, InvalidUserPass_Exception,
			MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager
				.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting
						.getEndpoint();
				return endpoint.deleteMonitor(monitorId, monitorTypeId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteMonitor(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static MonitorInfo getMonitor(String monitorId, String monitorTypeId)
			throws HinemosUnknown_Exception,
			InvalidRole_Exception, InvalidUserPass_Exception,
			MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager
				.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting
						.getEndpoint();
				return endpoint.getMonitor(monitorId, monitorTypeId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getMonitor(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void setStatusMonitor(String monitorId, String monitorTypeId, boolean validFlag)
			throws HinemosUnknown_Exception,
			InvalidRole_Exception, InvalidUserPass_Exception,
			MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager
				.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting
						.getEndpoint();
				endpoint.setStatusMonitor(monitorId, monitorTypeId, validFlag);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("setStatusMonitor(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void setStatusCollector(String monitorId, String monitorTypeId, boolean validFlag)
			throws HinemosUnknown_Exception,
			InvalidRole_Exception, InvalidUserPass_Exception,
			MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager
				.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting
						.getEndpoint();
				endpoint.setStatusCollector(monitorId, monitorTypeId, validFlag);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("setStatusCollector(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	//////////////////////////////////////////////////////////////////////////////////////////
	//
	// 各監視機能用のメソッド
	//
	//////////////////////////////////////////////////////////////////////////////////////////

	public static List<JdbcDriverInfo> getJdbcDriverList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getJdbcDriverList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getJdbcDriverList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	//////////////////////////////////////////////////////////////////////////////////////////
	//
	// 各監視機能用のリスト取得メソッド
	//
	//////////////////////////////////////////////////////////////////////////////////////////

	public static List<MonitorInfo> getAgentList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getAgentList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getAgentList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getHttpList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getHttpList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getHttpList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getLogfileList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getLogfileList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getLogfileList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getPerformanceList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getPerformanceList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getPerformanceList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getPingList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getPingList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getPingList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getPortList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getPortList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getPortList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getProcessList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getProcessList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getProcessList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getTrapList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getTrapList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getTrapList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getSnmpList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getSnmpList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getSnmpList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getSqlList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getSqlList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getSqlList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getSystemlogList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getSystemlogList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getSystemlogList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getCommandList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getCustomList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getCommandList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<MonitorInfo> getWinServiceList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getWinServiceList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getWinServiceList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
	
	public static List<MonitorInfo> getWinEventList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSettingEndpoint()) {
			try {
				MonitorSettingEndpoint endpoint = (MonitorSettingEndpoint) endpointSetting.getEndpoint();
				return endpoint.getWinEventList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getWinEventList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
}
