/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.action;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.notify.util.NotifyEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.InvalidRole_Exception;
import com.clustercontrol.ws.notify.NotifyInfo;

/**
 * 通知情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 1.0.0
 */
public class GetNotify {

	// ログ
	private static Log m_log = LogFactory.getLog( GetNotify.class );

	/**
	 * 通知情報を返します。<BR>
	 * マネージャにSessionBean経由でアクセスします。
	 * 
	 * @param notifyId 取得対象の通知ID
	 * @return 通知情報
	 * 
	 */
	public NotifyInfo getNotify(String notifyId) {

		NotifyInfo info = null;

		try {
			info = NotifyEndpointWrapper.getNotify(notifyId);
		} catch (InvalidRole_Exception e) {
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (Exception e) {
			m_log.warn("useCheck(), " + e.getMessage(), e);
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}
		return info;
	}

	/**
	 * 通知情報一覧を返します。<BR>
	 * マネージャにSessionBean経由でアクセスします。
	 * 
	 * @return 通知情報一覧
	 */
	public List<NotifyInfo> getNotifyList(){

		List<NotifyInfo> records = null;
		try {
			records = NotifyEndpointWrapper.getNotifyList();
		} catch (InvalidRole_Exception e) {
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (Exception e) {
			m_log.warn("getNotifyList(), " + e.getMessage(), e);
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}
		return records;
	}

	/**
	 * オーナーロールIDを条件として通知情報一覧を返します。<BR>
	 * マネージャにSessionBean経由でアクセスします。
	 * 
	 * @return 通知情報一覧
	 */
	public List<NotifyInfo> getNotifyListByOwnerRole(String ownerRoleId) throws InvalidRole_Exception{

		List<NotifyInfo> records = null;
		try {
			records = NotifyEndpointWrapper.getNotifyListByOwnerRole(ownerRoleId);
		} catch (InvalidRole_Exception e) {
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
			throw e;
		} catch (Exception e) {
			m_log.warn("getNotifyListByOwnerRole(), " + e.getMessage(), e);
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}
		return records;
	}
}