package com.clustercontrol.repository.util;

import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.WebServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.EndpointManager.EndpointSetting;
import com.clustercontrol.ws.access.UsedOwnerRole_Exception;
import com.clustercontrol.ws.repository.AgentStatusInfo;
import com.clustercontrol.ws.repository.FacilityDuplicate_Exception;
import com.clustercontrol.ws.repository.FacilityNotFound_Exception;

import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import com.clustercontrol.ws.repository.HinemosUnknown_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.InvalidSetting_Exception;
import com.clustercontrol.ws.repository.InvalidUserPass_Exception;
import com.clustercontrol.ws.repository.NodeInfo;
import com.clustercontrol.ws.repository.RepositoryEndpoint;
import com.clustercontrol.ws.repository.RepositoryTableInfo;
import com.clustercontrol.ws.repository.ScopeInfo;
import com.clustercontrol.ws.repository.UsedFacility_Exception;

/**
 * Hinemosマネージャとの通信をするクラス。
 * HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class RepositoryEndpointWrapper {

	// ログ
	private static Log m_log = LogFactory.getLog( RepositoryEndpointWrapper.class );

	public static List<RepositoryTableInfo> getPlatformList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getPlatformList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getPlatformList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void addNode(NodeInfo nodeInfo)
			throws FacilityDuplicate_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				endpoint.addNode(nodeInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("addNode(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void addScope(String parentId, ScopeInfo scopeInfo)
			throws FacilityDuplicate_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				endpoint.addScope(parentId, scopeInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("addScope(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void assignNodeScope(String scopeId, List<String> nodeId)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				endpoint.assignNodeScope(scopeId, nodeId);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("assignNodeScope(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void deleteNode(String facilityId)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UsedFacility_Exception, UsedOwnerRole_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				endpoint.deleteNode(facilityId);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteNode(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void deleteScope(String facilityId)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UsedFacility_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				endpoint.deleteScope(facilityId);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteScope(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static Long getLastUpdate() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getLastUpdate();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getLastUpdate(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static NodeInfo getNode(String facilityId)
			throws FacilityNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getNode(facilityId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getNode(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static NodeInfo getNodePropertyBySNMP(String ipAddress, int port, String community, String version)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getNodePropertyBySNMP(ipAddress, port, community, version);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getNodePropertyBySNMP(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<String> getNodeScopeList(String facilityId)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getNodeScopeList(facilityId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getNodeScopeList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<FacilityInfo> getFacilityList(String facilityId)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getFacilityList(facilityId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getScopeList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static ScopeInfo getScope(String facilityId)
			throws FacilityNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getScope(facilityId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getScope(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void modifyNode(NodeInfo nodeInfo)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				endpoint.modifyNode(nodeInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyNode(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void modifyScope(ScopeInfo scopeInfo)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				endpoint.modifyScope(scopeInfo);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyScope(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void releaseNodeScope(String scopeId, List<String> nodeIdList)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				endpoint.releaseNodeScope(scopeId, nodeIdList);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("releaseNodeScope(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<RepositoryTableInfo> getCollectorSubPlatformTableInfoList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getCollectorSubPlatformTableInfoList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getCollectorSubPlatformMstList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<String> getVmProtocolMstList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getVmProtocolMstList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getVmProtocolMstList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<RepositoryTableInfo> getHostList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getHostList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getHostList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<NodeInfo> getOpenFlowSwitchList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getOpenFlowSwitchList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getOpenFlowSwitchList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}


	public static String getFacilityPath(String facilityId, String parentFacilityId)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getFacilityPath(facilityId, parentFacilityId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getFacilityPath(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<NodeInfo> getFilterNodeList(NodeInfo nodeInfo)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getFilterNodeList(nodeInfo);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getFilterNodeList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<NodeInfo> getNodeList(String parentFacilityId, int level)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getNodeList(parentFacilityId, level);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getNodeList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<NodeInfo> getNodeListAll()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getNodeListAll();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getNodeListAll(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<AgentStatusInfo> getAgentStatusList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.getAgentStatusList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getAgentStatusList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static FacilityTreeItem getFacilityTree(String ownerRoleId)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				FacilityTreeItem item = endpoint.getFacilityTree(ownerRoleId);
				setTreeParent(item);
				return item;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getFacilityTree(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static FacilityTreeItem getExecTargetFacilityTreeByFacilityId(String facilityId, String ownerRoleId)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				FacilityTreeItem item = endpoint.getExecTargetFacilityTreeByFacilityId(facilityId, ownerRoleId);
				if(item != null)
					setTreeParent(item);
				return item;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getExecTargetFacilityTreeByFacilityId(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static FacilityTreeItem getNodeFacilityTree(String ownerRoleId)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				FacilityTreeItem item = endpoint.getNodeFacilityTree(ownerRoleId);
				if(item != null)
					setTreeParent(item);
				return item;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getNodeFacilityTree(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void setTreeParent(FacilityTreeItem item) {
		List<FacilityTreeItem> children = item.getChildren();
		for (FacilityTreeItem child : children) {
			child.setParent(item);
			setTreeParent(child);
		}
	}

	public static void restartAgent(ArrayList<String> facilityIdList, int agentCommand)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				endpoint.restartAgent(facilityIdList, agentCommand);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("restartAgent(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static String replaceNodeVariable(String facilityId, String replaceObject)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				return endpoint.replaceNodeVariable(facilityId, replaceObject);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("replaceNodeVariable(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
}
