package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;


/**
 * The persistent class for the cc_crun_cmd_param_mst database table.
 * 
 */
@Entity
@Table(name="cc_crun_cmd_param_mst")
@Cacheable(true)
public class CrunCmdParamMstEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private CrunCmdParamMstEntityPK id;
	private Integer orderNo;
	private String paramPrefix;
	private CrunCmdMstEntity crunCmdMstEntity;
	private CrunParamMstEntity crunParamMstEntity;

	@Deprecated
	public CrunCmdParamMstEntity() {
	}

	public CrunCmdParamMstEntity(CrunCmdParamMstEntityPK pk,
			CrunCmdMstEntity crunCmdMstEntity, CrunParamMstEntity crunParamMstEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToCrunCmdMstEntity(crunCmdMstEntity);
		this.relateToCrunParamMstEntity(crunParamMstEntity);
	}

	public CrunCmdParamMstEntity(String commandId, String paramId,
			CrunCmdMstEntity crunCmdMstEntity, CrunParamMstEntity crunParamMstEntity) {
		this(new CrunCmdParamMstEntityPK(commandId, paramId), crunCmdMstEntity, crunParamMstEntity);
	}

	@EmbeddedId
	public CrunCmdParamMstEntityPK getId() {
		return this.id;
	}

	public void setId(CrunCmdParamMstEntityPK id) {
		this.id = id;
	}


	@Column(name="order_no")
	public Integer getOrderNo() {
		return this.orderNo;
	}

	public void setOrderNo(Integer orderNo) {
		this.orderNo = orderNo;
	}


	@Column(name="param_prefix")
	public String getParamPrefix() {
		return this.paramPrefix;
	}

	public void setParamPrefix(String paramPrefix) {
		this.paramPrefix = paramPrefix;
	}


	//bi-directional many-to-one association to CrunCmdMstEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="command_id", insertable=false, updatable=false)
	public CrunCmdMstEntity getCrunCmdMstEntity() {
		return this.crunCmdMstEntity;
	}

	@Deprecated
	public void setCrunCmdMstEntity(CrunCmdMstEntity crunCmdMstEntity) {
		this.crunCmdMstEntity = crunCmdMstEntity;
	}

	/**
	 * CrunCmdMstEntityオブジェクト参照設定<BR>
	 * 
	 * CrunCmdMstEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToCrunCmdMstEntity(CrunCmdMstEntity crunCmdMstEntity) {
		this.setCrunCmdMstEntity(crunCmdMstEntity);
		if (crunCmdMstEntity != null) {
			List<CrunCmdParamMstEntity> list = crunCmdMstEntity.getCrunCmdParamMstEntities();
			if (list == null) {
				list = new ArrayList<CrunCmdParamMstEntity>();
			} else {
				for(CrunCmdParamMstEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			crunCmdMstEntity.setCrunCmdParamMstEntities(list);
		}
	}


	//bi-directional many-to-one association to CrunParamMstEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="param_id", insertable=false, updatable=false)
	public CrunParamMstEntity getCrunParamMstEntity() {
		return this.crunParamMstEntity;
	}

	@Deprecated
	public void setCrunParamMstEntity(CrunParamMstEntity crunParamMstEntity) {
		this.crunParamMstEntity = crunParamMstEntity;
	}

	/**
	 * CrunParamMstEntityオブジェクト参照設定<BR>
	 * 
	 * CrunParamMstEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToCrunParamMstEntity(CrunParamMstEntity crunParamMstEntity) {
		this.setCrunParamMstEntity(crunParamMstEntity);
		if (crunParamMstEntity != null) {
			List<CrunCmdParamMstEntity> list = crunParamMstEntity.getCrunCmdParamMstEntities();
			if (list == null) {
				list = new ArrayList<CrunCmdParamMstEntity>();
			} else {
				for(CrunCmdParamMstEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			crunParamMstEntity.setCrunCmdParamMstEntities(list);
		}
	}


	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// CrunParamMstEntity
		if (this.crunParamMstEntity != null) {
			List<CrunCmdParamMstEntity> list = this.crunParamMstEntity.getCrunCmdParamMstEntities();
			if (list != null) {
				Iterator<CrunCmdParamMstEntity> iter = list.iterator();
				while(iter.hasNext()) {
					CrunCmdParamMstEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}

		// CrunCmdMstEntity
		if (this.crunCmdMstEntity != null) {
			List<CrunCmdParamMstEntity> list = this.crunCmdMstEntity.getCrunCmdParamMstEntities();
			if (list != null) {
				Iterator<CrunCmdParamMstEntity> iter = list.iterator();
				while(iter.hasNext()) {
					CrunCmdParamMstEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}


}