package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;


/**
 * The persistent class for the cc_crun_param_select_mst database table.
 * 
 */
@Entity
@Table(name="cc_crun_param_select_mst")
@Cacheable(true)
public class CrunParamSelectMstEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private CrunParamSelectMstEntityPK id;
	private String nameId;
	private String paramValue;
	private CrunParamMstEntity crunParamMstEntity;

	@Deprecated
	public CrunParamSelectMstEntity() {
	}

	public CrunParamSelectMstEntity(CrunParamSelectMstEntityPK pk,
			CrunParamMstEntity crunParamMstEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToCrunParamMstEntity(crunParamMstEntity);
	}

	public CrunParamSelectMstEntity(String paramId, Integer orderNo,
			CrunParamMstEntity crunParamMstEntity) {
		this(new CrunParamSelectMstEntityPK(paramId, orderNo), crunParamMstEntity);
	}

	@EmbeddedId
	public CrunParamSelectMstEntityPK getId() {
		return this.id;
	}

	public void setId(CrunParamSelectMstEntityPK id) {
		this.id = id;
	}


	@Column(name="name_id")
	public String getNameId() {
		return this.nameId;
	}

	public void setNameId(String nameId) {
		this.nameId = nameId;
	}


	@Column(name="param_value")
	public String getParamValue() {
		return this.paramValue;
	}

	public void setParamValue(String paramValue) {
		this.paramValue = paramValue;
	}


	//bi-directional many-to-one association to CrunParamMstEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="param_id", insertable=false, updatable=false)
	public CrunParamMstEntity getCrunParamMstEntity() {
		return this.crunParamMstEntity;
	}

	@Deprecated
	public void setCrunParamMstEntity(CrunParamMstEntity crunParamMstEntity) {
		this.crunParamMstEntity = crunParamMstEntity;
	}

	/**
	 * CrunParamMstEntityオブジェクト参照設定<BR>
	 * 
	 * CrunParamMstEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToCrunParamMstEntity(CrunParamMstEntity crunParamMstEntity) {
		this.setCrunParamMstEntity(crunParamMstEntity);
		if (crunParamMstEntity != null) {
			List<CrunParamSelectMstEntity> list = crunParamMstEntity.getCrunParamSelectMstEntities();
			if (list == null) {
				list = new ArrayList<CrunParamSelectMstEntity>();
			} else {
				for(CrunParamSelectMstEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			crunParamMstEntity.setCrunParamSelectMstEntities(list);
		}
	}

	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// CrunParamMstEntity
		if (this.crunParamMstEntity != null) {
			List<CrunParamSelectMstEntity> list = this.crunParamMstEntity.getCrunParamSelectMstEntities();
			if (list != null) {
				Iterator<CrunParamSelectMstEntity> iter = list.iterator();
				while(iter.hasNext()) {
					CrunParamSelectMstEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}