package com.clustercontrol.jobmanagement.model;

import java.io.Serializable;
import java.util.Arrays;

import javax.persistence.*;

/**
 * The primary key class for the cc_job_notice_mst database table.
 * 
 */
@Embeddable
public class JobNoticeMstEntityPK implements Serializable {
	//default serial version id, required for serializable classes.
	private static final long serialVersionUID = 1L;
	private String jobunitId;
	private String jobId;
	private Integer noticeType;

	public JobNoticeMstEntityPK() {
	}

	public JobNoticeMstEntityPK(String jobunitId, String jobId, Integer noticeType) {
		this.setJobunitId(jobunitId);
		this.setJobId(jobId);
		this.setNoticeType(noticeType);
	}

	@Column(name="jobunit_id")
	public String getJobunitId() {
		return this.jobunitId;
	}
	public void setJobunitId(String jobunitId) {
		this.jobunitId = jobunitId;
	}

	@Column(name="job_id")
	public String getJobId() {
		return this.jobId;
	}
	public void setJobId(String jobId) {
		this.jobId = jobId;
	}

	@Column(name="notice_type")
	public Integer getNoticeType() {
		return this.noticeType;
	}
	public void setNoticeType(Integer noticeType) {
		this.noticeType = noticeType;
	}

	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof JobNoticeMstEntityPK)) {
			return false;
		}
		JobNoticeMstEntityPK castOther = (JobNoticeMstEntityPK)other;
		return
				this.jobunitId.equals(castOther.jobunitId)
				&& this.jobId.equals(castOther.jobId)
				&& this.noticeType.equals(castOther.noticeType);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int hash = 17;
		hash = hash * prime + this.jobunitId.hashCode();
		hash = hash * prime + this.jobId.hashCode();
		hash = hash * prime + this.noticeType.hashCode();

		return hash;
	}

	@Override
	public String toString() {
		String[] names = {
				"jobunitId",
				"jobId",
				"noticeType"
		};
		String[] values = {
				this.jobunitId,
				this.jobId,
				this.noticeType.toString()
		};
		return Arrays.toString(names) + " = " + Arrays.toString(values);
	}
}