/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.cloudn.base.commons.util.CloudnConstants;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.presenter.JobTrackingService;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateInstanceDialog_FLAT;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceByTemplateRequest;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.InvalidStateException;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.InstancesView;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;

public class CreateInstanceAction_FLAT
extends AbstractViewAction
implements CloudnConstants {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgCreateInstanceConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance", "word.create"});
    private String msgCreateInstanceResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.create"});

    protected void invoke(IAction action) throws InvocationException {
        CreateInstanceDialog_FLAT dialog = new CreateInstanceDialog_FLAT(this.viewPart.getSite().getShell());
        InstancesView view = (InstancesView)this.viewPart;
        IAccountResource.IRegion region = view.getActiveRegion();
        if (region == null) {
            assert (view.getCurrentAccountResource().getRegions().length > 0);
            region = view.getCurrentAccountResource().getRegions()[0];
        }
        ICloudTemplateManager templateManager = region.getAccountResource().getCloudTemplateManager();
        dialog.setCloudTemplateManager(templateManager);
        dialog.setCloudInfoProvider(new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId()));
        dialog.setRegion(region.getRegion());
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateInstanceConfirm)) {
                ICloudInstance instance;
                CreateCloudInstanceByTemplateRequest request;
                String detailJson;
                CreateInstanceDialog_FLAT.Model m = dialog.getOutput();
                ICloudComputeService service = (ICloudComputeService)region.getCloudService(ICloudComputeService.class);
                IAccountResource.IRegion r = service.getRegion();
                InstanceDetail detail = new InstanceDetail();
                if (m.getSecurityGroups() != null && !m.getSecurityGroups().isEmpty()) {
                    detail.securityGroups.addAll(m.getSecurityGroups());
                }
                detail.group = m.getGroup();
                detail.attachingDisk = m.getAttachingDisk();
                ObjectMapper om = new ObjectMapper();
                ObjectWriter dw = om.writerWithType(InstanceDetail.class);
                try {
                    detailJson = dw.writeValueAsString((Object)detail);
                }
                catch (Exception e) {
                    throw new CloudModelException((Throwable)e);
                }
                if (m.isTemplateUsed().booleanValue()) {
                    request = new CreateCloudInstanceByTemplateRequest();
                    request.setZone(m.getZone());
                    request.setTemplateId(m.getTemplateId());
                    request.setFlavor(m.getFlavor());
                    request.setFacilityId(m.getFacilityId());
                    request.setFacilityName(m.getFacilityName());
                    request.setDescription(m.getDescription());
                    request.setNodeName(m.getNodeName());
                    request.setReplaceNode(m.getReplaceNode());
                    request.setInstanceDetail(detailJson);
                    request.setTags(m.getTags());
                    request.setArguments(m.getArguments());
                    instance = ((ICloudComputeService)r.getAccountResource().getRegion("jp-e1").getCloudService(ICloudComputeService.class)).getInstanceManager().createCloudInstanceByTemplate(request);
                } else {
                    request = new CreateCloudInstanceRequest();
                    request.setZone(m.getZone());
                    request.setImageId(m.getImageId());
                    request.setFlavor(m.getFlavor());
                    request.setFacilityId(m.getFacilityId());
                    request.setFacilityName(m.getFacilityName());
                    request.setDescription(m.getDescription());
                    request.setNodeName(m.getNodeName());
                    request.setReplaceNode(m.getReplaceNode());
                    request.setInstanceDetail(detailJson);
                    request.setTags(m.getTags());
                    instance = ((ICloudComputeService)r.getAccountResource().getRegion("jp-e1").getCloudService(ICloudComputeService.class)).getInstanceManager().createCloudInstance((CreateCloudInstanceRequest)request);
                }
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateInstanceResult);
                try {
                    JobTrackingService.trackPassword((IViewPart)view, instance);
                }
                catch (InvalidStateException e) {
                    throw new InvocationException((Throwable)e);
                }
                view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, new ICloudInstance.StateType[]{ICloudInstance.StateType.running, ICloudInstance.StateType.terminated, ICloudInstance.StateType.stopped});
                        FacilityTree.refresh();
                    }
                });
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }

    public static class InstanceDetail {
        public List<String> securityGroups = new ArrayList<String>();
        public Boolean attachingDisk;
        public String group;
    }
}

