/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;

public abstract class ErrorHandler {
    public void execute(IAction action) {
        try {
            this.invoke(action);
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof InvocationException && e.getCause() != null) {
                t = e.getCause();
            }
            if (e instanceof CloudModelException) {
                if (e.getCause() != null) {
                    t = e.getCause();
                }
            } else if (e instanceof IllegalStateException && e.getCause() != null) {
                t = e.getCause();
            }
            Logger logger = Logger.getLogger(ErrorHandler.class);
            logger.error((Object)t.getMessage(), t);
            String message = t.getMessage();
            if (message == null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bos, true);
                t.printStackTrace(ps);
                message = bos.toString();
            }
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)message);
        }
    }

    protected abstract void invoke(IAction var1) throws InvocationException;
}

