/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.commons.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.RequiredFieldColorConstant;

public class ControlUtilEx {
	public static void setRequired(Control...requiredControls){
		for(Control requiredControl: requiredControls){
			if(requiredControl instanceof Text){
				final Text text = (Text)requiredControl;
				if(text.getEnabled() && text.getText().isEmpty()){
					requiredControl.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				}
				text.addModifyListener(new ModifyListener(){
					@Override
					public void modifyText(ModifyEvent e) {
						if(text != null && text.getEnabled() && text.getEditable() && text.getText().isEmpty()){
							text.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
						} else if(text != null) {
							text.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
						}
					}
				});
			}
			else if(requiredControl instanceof Combo){
				if(((Combo)requiredControl).getText().equals("")){
					requiredControl.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				}
				((Combo)requiredControl).addModifyListener(new ModifyListener(){
					@Override
					public void modifyText(ModifyEvent e) {
						if(((Combo)e.getSource()).getText().equals("") || ((Combo)e.getSource()).indexOf(((Combo)e.getSource()).getText()) == -1){
							((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
						} else {
							((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
						}
					}
				});
				((Combo)requiredControl).addKeyListener(new KeyAdapter(){
					@Override
					public void keyPressed(KeyEvent e) {
						if(!Character.isISOControl(e.character) || e.character == SWT.BS || e.character == SWT.DEL){
							e.doit = false;
						}
					}
				});
			}
		}
	}
}
