/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.cloud.cloudn.base.commons.util.CloudnConstants;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.cloud.cloudn.base.resources.Zone;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateTemplateDialog;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateTemplateDialog.DialogControlContainer;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.SelectVMIDialog;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;


public class CreateTemplateAction extends AbstractViewAction {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgCreateTemplateConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.template", "word.create"});
	private String msgCreateTemplateResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.template", "word.create"});

	private CloudResourceProvider provider;
	private IRegion region;
	
	@Override
	protected void invoke(IAction action) throws InvocationException {
		final IAccountResource accountResource = ((TemplatesView)viewPart).getAccountResource();
		provider = new CloudResourceProviderImpl(accountResource.getAccountResourceId());
		
		if(((TemplatesView)viewPart).getActiveRegion() != null){
			region = ((TemplatesView)viewPart).getActiveRegion();
		} else {
			region = accountResource.getRegion(CloudnConstants.DEFAULT_REGION);
		}
		
		final CreateTemplateDialog dialog = new CreateTemplateDialog(this.viewPart.getSite().getShell());
		dialog.setCloudInfoProvider(provider);
		try {
			dialog.setBehavior(new CreateTemplateDialog.IDialogBehavior(){
				@Override
				public void setup(final DialogControlContainer container) {
					MessageManagerExt messages = MessageManagerExt.getInstance("messages");
					List<TemplateJobUtil.TemplateJobnet> templateJobs;
					
					container.getCmbRegion().addModifyListener(new ModifyListener() {
						public void modifyText(ModifyEvent e) {
							setupZone(container);
							container.getTxtVmi().setText("");
							container.getTxtVmi().setData(null);
						}
					});

					container.getCmbZone().addModifyListener(new ModifyListener() {
						@Override
						public void modifyText(ModifyEvent e) {
							container.getTxtVmi().setText("");
							container.getTxtVmi().setData(null);
						}
					});
					
					try{
						templateJobs = TemplateJobUtil.getTemplateJobList(accountResource.getAccountResourceId(), true);
					} catch(Exception e) {
						MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
						templateJobs = new ArrayList<TemplateJobUtil.TemplateJobnet>();
					}

					for (String regionName: provider.getAllRegion()) {
						String regionLocaleName = messages.getString(regionName);
						container.getCmbRegion().add(regionLocaleName);
						container.getCmbRegion().setData(regionLocaleName, regionName);
					}
					if (region != null) {
						String regionLocaleName = messages.getString(region.getRegionName());
						container.getCmbRegion().select(container.getCmbRegion().indexOf(regionLocaleName));
					} else {
						container.getCmbRegion().select(0);
					}

					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						container.getCmbLaunchJobId().add(jobName);
						container.getCmbLaunchJobId().setData(jobName, jobId);
					}

					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						container.getCmbStartJobId().add(jobName);
						container.getCmbStartJobId().setData(jobName, jobId);
					}

					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						container.getCmbStopJobId().add(jobName);
						container.getCmbStopJobId().setData(jobName, jobId);
					}
					
					final Shell shell = dialog.getShell();
					container.getBtnSelectVmi().addSelectionListener(new SelectionAdapter(){
						@Override
						public void widgetSelected(SelectionEvent e) {
							List<Template> officials = provider.getTemplates(CloudnConstants.DEFAULT_REGION, Arrays.asList(new Filter("category", "official"), new Filter("zone", container.getCmbZone().getText())));
							List<Template> mys = provider.getTemplates(CloudnConstants.DEFAULT_REGION, Arrays.asList(new Filter("category", "my"), new Filter("zone", container.getCmbZone().getText())));
							SelectVMIDialog dialog = new SelectVMIDialog(officials, mys, shell);
							if (dialog.open() == Window.OK) {
								Template output = dialog.getOutput();
								container.getTxtVmi().setText(output.getName() + " ( " + output.getId() + " ) ");
								container.getTxtVmi().setData(output);
							}
						}
					});
				}
				
				private void setupZone(DialogControlContainer container){
					container.getCmbZone().removeAll();
					
					for(Zone zone: provider.getZones(region.getRegion())){
						container.getCmbZone().add(zone.getName());
						container.getCmbZone().setData(zone.getName(), zone);
					}
					if(container.getCmbZone().getItemCount() > 0){
						container.getCmbZone().select(0);
					}
				}
			});
		} catch (Exception e) {
			throw new InvocationException(e);
		}

		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgCreateTemplateConfirm)) {

				ICloudTemplateManager templateManager = accountResource.getCloudTemplateManager();
				
				templateManager.createCloudTemplate(dialog.getOutput());
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgCreateTemplateResult);
			}
			else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if(((TemplatesView)viewPart).getAccountResource() != null){
			action.setEnabled(true);
		} else {
			action.setEnabled(false);
		}
	}
}