/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DebugUtil {
    public static void printObject(Object obj) {
        System.out.println("printing props of " + obj.getClass().getSimpleName() + "...");
        DebugUtil.recursive(obj, null);
    }

    private static void recursive(Object obj, String prefix) {
        Pattern p = Pattern.compile("^(get|is)(.+)$");
        for (Method method : obj.getClass().getMethods()) {
            if (method.getReturnType() == Class.class || method.getReturnType() == Void.class || method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
            String propName = null;
            Matcher m = p.matcher(method.getName());
            if (!m.matches()) continue;
            propName = m.group(2);
            propName = propName.substring(0, 1).toLowerCase() + propName.substring(1);
            try {
                String qualifiedPropName;
                String string = qualifiedPropName = prefix != null ? prefix + "." + propName : propName;
                if (method.getReturnType() == Long.class && (propName.toLowerCase().contains("date") || propName.toLowerCase().contains("time"))) {
                    System.out.println("\t" + qualifiedPropName + " " + new Date((Long)method.invoke(obj, new Object[0])).toString());
                    continue;
                }
                if (method.getReturnType().isPrimitive() || Number.class.isAssignableFrom(method.getReturnType()) || method.getReturnType() == Boolean.class || method.getReturnType() == String.class || method.getReturnType() == Date.class || Enum.class.isAssignableFrom(method.getReturnType())) {
                    System.out.println("\t" + qualifiedPropName + " " + method.invoke(obj, new Object[0]));
                    continue;
                }
                if (method.getReturnType() == List.class) {
                    List list = (List)method.invoke(obj, new Object[0]);
                    if (list.isEmpty()) {
                        DebugUtil.recursive(list, qualifiedPropName);
                        continue;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        DebugUtil.recursive(list.get(i), qualifiedPropName + "[" + i + "]");
                    }
                    continue;
                }
                Object prop = method.invoke(obj, new Object[0]);
                if (prop == null) {
                    System.out.println("\t" + propName + " " + null);
                    continue;
                }
                DebugUtil.recursive(prop, qualifiedPropName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

