/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlTransient;

import com.clustercontrol.cloud.dao.CloudTypeDao;
import com.clustercontrol.cloud.validation.annotation.ReadOnly;

public class CloudType implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -2147835401052595306L;

	private CloudTypeDao data;

	public CloudType() {
		super();
		this.data = new CloudTypeDao();
	}

	public CloudType(CloudTypeDao tableData) {
		super();
		this.data = new CloudTypeDao(tableData);
	}
	@ReadOnly
	public String getCloudId() {
		return data.getId();
	}

	public void setCloudId(String cloudId) {
		data.setCloudId(cloudId);
	}
	@ReadOnly
	public String getCloudName() {
		return data.getName();
	}

	public void setCloudName(String cloudName) {
		data.setName(cloudName);
	}
	@ReadOnly
	public String getDescription() {
		return data.getDescription();
	}

	public void setDescription(String description) {
		data.setDescription(description);
	}
	@XmlTransient
	public CloudTypeDao getTableData() {
		return data;
	}
}