/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.factory.CloudAccessorUtil;
import com.clustercontrol.cloud.util.AuthorizingUtil;
import com.clustercontrol.cloud.validation.CustomEntityValidator;
import com.clustercontrol.cloud.validation.EntityValidator.EntityValidationContext;
import com.clustercontrol.cloud.validation.ValidationConstants;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.annotation.CustomEntityValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;

@CustomEntityValidation(CreateCloudUserRequest.CloudUserValidator.class)
public class CreateCloudUserRequest {
	public static class CloudUserValidator implements CustomEntityValidator<CreateCloudUserRequest>, ValidationConstants {
		@Override
		public void validate(final CreateCloudUserRequest entity, String group, IMessagesHolder messages, EntityValidationContext context) throws ValidationFault {
			try {
				if (
					!AuthorizingUtil.checkHinemousUser_administrators_account(SessionService.current().getHinemosCredential().getUserId(), entity.getAccountResourceId())
					) {
					throw ErrorCode.NEED_ADMINISTRATORS_ROLE_OR_ACCOUNT_USER.cloudManagerFault(SessionService.current().getHinemosCredential().getUserId(), entity.getAccountResourceId());
				}
				
				// クラウド側にユーザー情報が存在するか確認。
				CloudAccessorUtil.getUser(entity.getAccountResourceId(), entity.getAccessKey(), entity.getSecretKey());
			}
			catch (CloudManagerFault e) {
				throw new ValidationFault(e.getMessage(), e.getErrorCode(), e);
			}
		}
	}

	private String cloudUserId;
	private String cloudUserName;
	private String accountResourceId;
	private String description;
	private String accessKey;
	private String secretKey;
	private String roleId;
	
	@ElementId("cloudUserId")
	@Identity
	public String getCloudUserId() {
		return cloudUserId;
	}
	public void setCloudUserId(String cloudUserId) {
		this.cloudUserId = cloudUserId;
	}
	@ElementId("cloudUserName")
	@NotNull
	@Size(max=128)
	public String getCloudUserName() {
		return cloudUserName;
	}
	public void setCloudUserName(String cloudUserName) {
		this.cloudUserName = cloudUserName;
	}
	@ElementId("accountResourceId")
	@Identity
	public String getAccountResourceId() {
		return accountResourceId;
	}
	public void setAccountResourceId(String accountResourceId) {
		this.accountResourceId = accountResourceId;
	}
	@ElementId("description")
	@Size(max = 256)
	@NotNull
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	@ElementId("accessKey")
	@Size(max = 64)
	@NotNull
	public String getAccessKey() {
		return accessKey;
	}
	public void setAccessKey(String accessKey) {
		this.accessKey = accessKey;
	}
	@ElementId("secretKey")
	@Size(max = 64)
	@NotNull
	public String getSecretKey() {
		return secretKey;
	}
	public void setSecretKey(String secretKey) {
		this.secretKey = secretKey;
	}
	@ElementId("roleId")
	@Identity
	public String getRoleId() {
		return roleId;
	}
	public void setRoleId(String roleId) {
		this.roleId = roleId;
	}
}