/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud;

public class PluginFault extends Exception {
	/**
	 * 
	 */
	private static final long serialVersionUID = -7755504233825235753L;

	private String errorCode;

	public PluginFault() {
		this(PluginBaseMessages.getString("message.unexpected_error"));
	}

	public PluginFault(String message, Throwable cause) {
		super(message, cause);
		setErrorCode(getDefaultErrorCode());
	}

	public PluginFault(String message, String errorCode, Throwable cause) {
		super(message, cause);
		setErrorCode(errorCode);
	}

	public PluginFault(String message) {
		super(message);
		setErrorCode(getDefaultErrorCode());
	}

	public PluginFault(String message, String errorCode) {
		super(message);
		setErrorCode(errorCode);
	}

	public PluginFault(Throwable cause) {
		super(cause instanceof PluginFault ? ((PluginFault)cause).getUndecoratedMessage():(cause.getMessage() == null ? cause.toString(): cause.getMessage()), cause);
		setErrorCode(cause instanceof PluginFault ? ((PluginFault)cause).getErrorCode():getDefaultErrorCode());
	}

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorCode() {
		return errorCode;
	}

	public String getDefaultErrorCode() {
		return "UNEXPECTED";
	}

	@Override
	public String getMessage() {
		return super.getMessage() + " : ErrorCode=" + errorCode;
	}

	public String getUndecoratedMessage() {
		return super.getMessage();
	}
}