/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.cloudn.rest.api.MarshalParam;

@NonNullByDefault(false)
@MarshalParam
public class CreateTemplateRequest extends RestApplicationRequest {
	// テンプレートの表示名指定する　必須
	public String displaytext;
	// テンプレート名を指定する　必須
	public String name;
	// テンプレートのOSタイプを指定する　必須
	public String ostypeid;
	// 32もしくは64ビットを指定する
	public Integer bits;
	// テンプレートの詳細を指定する。（key/value形式）
	public String details;
	// public テンプレートかどうかを指定する（true/false） 
	public Boolean ispublic;
	// パスワード変更の可否を指定する
	public Boolean passwordenabled;
	// 生成元のSnapshot IDを指定する　volumeidといずれか必須
	public String snapshotid;
	// テンプレートタグを指定する 
	public String templatetag;
	// 生成元のRootディスクのボリュームIDを指定する　snapshotidといずれか必須
	public String volumeid;
	
	public CreateTemplateRequest withDisplaytext(String displaytext) {
		this.displaytext = displaytext;
		return this;
	}
	public CreateTemplateRequest withName(String name) {
		this.name = name;
		return this;
	}
	public CreateTemplateRequest withOstypeid(String ostypeid) {
		this.ostypeid = ostypeid;
		return this;
	}
	public CreateTemplateRequest withBits(Integer bits) {
		this.bits = bits;
		return this;
	}
	public CreateTemplateRequest withDetails(String details) {
		this.details = details;
		return this;
	}
	public CreateTemplateRequest withIspublic(Boolean ispublic) {
		this.ispublic = ispublic;
		return this;
	}
	public CreateTemplateRequest withPasswordenabled(Boolean passwordenabled) {
		this.passwordenabled = passwordenabled;
		return this;
	}
	public CreateTemplateRequest withSnapshotid(String snapshotid) {
		this.snapshotid = snapshotid;
		return this;
	}
	public CreateTemplateRequest withTemplatetag(String templatetag) {
		this.templatetag = templatetag;
		return this;
	}
	public CreateTemplateRequest withVolumeid(String volumeid) {
		this.volumeid = volumeid;
		return this;
	}
}