/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(false)
@XmlRootElement(name="listapisresponse")
public class ListApisResponse extends CloudnResponse {
	@XmlRootElement(name="api")
	public static class Api {
		@XmlRootElement(name="params")
		public static class Param {
			public String name;
			public String description;
			public String type;
			public Integer length;
			public Boolean required;
			public String related;
		}
		@XmlRootElement(name="response")
		public static class Response {
			public String name;
			public String description;
			public String type;
		}
		
		public String name;
		public String description;
		public Boolean isasync;
		public String related;
		
		public List<Param> params;
		@XmlElement(name="response")
		public List<Response> responses;
	}
	
	@XmlAttribute(name="cloud-stack-version")
	public String cloud_stack_version;
	public int count;
	@XmlElement(name="api")
	public List<Api> apis = new ArrayList<>();
}