/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.eclipse.jdt.annotation.NonNullByDefault;


@NonNullByDefault(false)
@XmlRootElement(name="listpublicipaddressesresponse")
public class ListPublicIpAddressesResponse extends CloudnResponse {
	@XmlRootElement(name="publicipaddress")
	public static class PublicIpAddress {
		// public IP address id
		public String id;
		// the account the public IP address is associated with
		public String account;
		// date the public IP address was acquired
		public String allocated;
		// 	the ID of the Network associated with the IP address
		public String associatednetworkid;
		// the name of the Network associated with the IP address
		public String associatednetworkname;
		// the domain the public IP address is associated with
		public String domain;
		// the domain ID the public IP address is associated with
		public String domainid;
		// the virtual network for the IP address
//		public String forvirtualnetwork;
		// public IP address
		public String ipaddress;
		// true if the IP address is a source nat address, false otherwise
		public Boolean issourcenat;
		// true if this ip is for static nat, false otherwise
		public Boolean isstaticnat;
		// true if this ip is system ip (was allocated as a part of deployVm or createLbRule)
		public Boolean issystem;
		// 
		public Boolean isportable;
		// the ID of the Network where ip belongs to
		public String networkid;
		// the physical network this belongs to
		public String physicalnetworkid;
		// the project name of the address
		public String project;
		// the project id of the ipaddress
		public String projectid;
		// purpose of the IP address. In Acton this value is not null for Ips with isSystem=true, and can have either StaticNat or LB value
		public String purpose;
		// State of the ip address. Can be: Allocatin, Allocated and Releasingvirtualmachine
		public String state;
		// virutal machine display name the ip address is assigned to (not null only for static nat Ip)
		public String virtualmachinedisplayname;
		// virutal machine id the ip address is assigned to (not null only for static nat Ip)
		public String virtualmachineid;
		// virutal machine name the ip address is assigned to (not null only for static nat Ip)
		public String virtualmachinename;
		//
		public String vmipaddress;
		// the ID of the VLAN associated with the IP address
		public String vlanid;
		// the VLAN associated with the IP address
		public String vlanname;
		// VPC the ip belongs to
		public String vpcid;
		// the ID of the zone the public IP address belongs to
		public String zoneid;
		// the name of the zone the public IP address belongs to
		public String zonename;
		// (*)the list of resource tags associated with ip address
		//    account the account associated with the tag
		//    customer customer associated with the tag
		//    domain the domain associated with the tag
		//    domainid the ID of the domain associated with the tag
		//    key tag key name
		//    project the project name where tag belongs to
		//    projectid the project id the tag belongs to
		//    resourceid id of the resource
		//    resourcetype resource type
		//    value tag value
		public List<Tag> tags;
//		// the ID of the latest async job acting on this object
//		public String jobid;
//		// the current status of the latest async job acting on this object
//		public String jobstatus;
	}
	
	@XmlAttribute(name="cloud-stack-version")
	public String cloud_stack_version;
	public int count;
	@XmlElement(name="publicipaddress")
	public List<PublicIpAddress> publicipaddresses = new ArrayList<>();
}
