/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import java.util.List;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.cloudn.rest.api.MarshalParam;
import com.clustercontrol.cloud.cloudn.rest.api.TagParamMarshaller;
import com.google.common.base.Preconditions;

@NonNullByDefault(false)
@MarshalParam
public class ListTemplateRequest extends RestApplicationRequest  {
	//	以下のいずれかを指定する。 
	//	• featured 
	//	 (注: Cloudn Compute VPCタイプ OpenNW Typeサービスで提供しているオフィシャルテンプレート
	//	一覧を取得するためのフィルター) 
	//	• self 
	//	 (注: 自作または持ち込みテンプレート一覧を取得するためのフィルター ) 
	//	• self-executable 
	//	 (注：自作、持ち込みテンプレートで、かつ新しいVMを作成するのに利用できるテンプレート一覧を取
	//	得するフィルター) 
	//	• executable 
	//	 (注：新しいVMを作成するのに利用できるテンプレート一覧を取得するフィルター) 
	//	Yes
	public String templatefilter;
	 // 指定したアカウントに属する情報に絞り込む。domainidと同時に利用する No
	public String account; 
	// ドメインIDを指定する。指定することにより、指定したドメイン以下の情報に絞り込む No
	public String domainid;
	// Hypervisor を指定。 No
	public String hypervisor;
	// テンプレートのIDを指定 No
	public String id;
	// サブドメインが保有するテンプレートも検索対象とする No
	public boolean isrecursive;
	// キーワードによる検索を実施する No
	public String keyword;
	// true/ falseで指定する(default false). zoneidとisrecursive=trueと設定した場合に等しい No
	public boolean listall;
	// テンプレート名を指定して、検索を実施する No
	public String name;
	// pagesizeと同時に指定して、ページ番号を指定する No
	public Integer page;
	// 一度のリクエストに含めるレスポンス(非同期ジョブ)の個数を指定する。pageと同時にしていする.(default: 500) No 
	public Integer pagesize;
	//	タグ情報（key, value）による検索条件を指定する。 
	//	タグ情報は、 
	//	 
	//	 tags[N].key=“sample_key” 
	//	 tags[N].value=“sample_value” 
	//	 （N=0, 1, 2, 3, ….） 
	//	 
	//	の形で指定する 
	//	No
	@MarshalParam(TagParamMarshaller.class)
	public List<RTag> tags;
	// テンプレートの存在するゾーンを指定する No
	public String zoneid;
	
	public ListTemplateRequest withId(@NonNull String id) {
		Preconditions.checkNotNull(id);
		this.id = id;
		return this;
	}

	public ListTemplateRequest withTemplatefilter(@NonNull String templatefilter) {
		Preconditions.checkNotNull(templatefilter);
		this.templatefilter = templatefilter;
		return this;
	}
	
	public ListTemplateRequest withZoneId(@NonNull String zoneid) {
		Preconditions.checkNotNull(zoneid);
		this.zoneid = zoneid;
		return this;
	}
	
	public ListTemplateRequest withKeyword(@NonNull String keyword) {
		Preconditions.checkNotNull(keyword);
		this.keyword = keyword;
		return this;
	}
}
