/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.cloudn.rest.api.MarshalParam;
import com.clustercontrol.cloud.cloudn.rest.api.TagParamMarshaller;
import com.google.common.base.Preconditions;

@NonNullByDefault(false)
@MarshalParam
public class ListVirtualMachinesRequest extends RestApplicationRequest {
	// domainidと共に使用して、任意のアカウントを指定する No
	public String account;
	// 詳細情報を取得する。指定出来る値は、all, group, nics, stats, secgrp, tmpl, servoff, iso, volume及びmin。また、複数指定する場合は、カンマ（,） で区切り指定する No
	public String details;
	// domainid を指定する No
	public String domainid;
	// VM Group のIDを指定する No
	public String groupid;
	// 仮想マシンのIDを指定する No
	public String id;
	// 仮想マシンをisoidにより指定する No
	public String isoid;
	// サブドメインを検索対象に含める No
	public String isrecursive;
	// 仮想マシンをキーワードにより指定する No
	public String keyword;
	// true/ falseで指定する(default false). zoneidとisrecursive=trueと設定した場合に等しい No
	public String listall;
	// 仮想マシンを名前により指定する No
	public String name;
	// pagesizeと同時に指定して、ページ番号を指定する No
	public String page;
	// 一度のリクエストに含めるレスポンス(非同期ジョブ)の個数を指定する。pageと同時にしていする.(default: 500)No
	public String pagesize;
	// 仮想マシンの状態（Running, Stopped等）により、仮想マシンを指定する No
	public String state; 
	// タグ情報（key, value）による検索条件を指定する。 タグ情報は、 tags[N].key=“sample_key” tags[N].value=“sample_value” （N=0, 1, 2, 3, ….） の形で指定する  No
	@MarshalParam(TagParamMarshaller.class)
	public List<RTag> tags = new ArrayList<>();
	// 仮想マシンをテンプレートIDにより指定する No
	public String templateid;
	// 仮想マシンをZone idにより指定する No
	public String zoneid;
	
	public ListVirtualMachinesRequest withId(@NonNull String id) {
		Preconditions.checkNotNull(id);
		this.id = id;
		return this;
	}
}
