/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

/**
 * インスタンス情報のBMP Entity Bean クラス<BR>
 */
@Entity
@Table(name="cc_cloud_resource_store")
@IdClass(CloudResourceStoreDao.CloudResourceStorePK.class)
public class CloudResourceStoreDao extends DaoBase {
	public static class CloudResourceStorePK {
		private String resourceId;
		private String resourceType;
		private String accountResourceId;
		private String region;

		public CloudResourceStorePK() {
		}

		public CloudResourceStorePK(String resourceId, String resourceType, String region, String accountResourceId) {
			this.resourceId = resourceId;
			this.resourceType = resourceType;
			this.accountResourceId = accountResourceId;
			this.region = region;
		}

		public String getResourceType() {
			return resourceType;
		}
		public void setResourceType(String resourceType) {
			this.resourceType = resourceType;
		}

		public String getAccountResourceId() {
			return accountResourceId;
		}
		public void setAccountResourceId(String AccountResourceId) {
			this.accountResourceId = AccountResourceId;
		}

		public String getRegion()
		{
			return this.region;
		}
		public void setRegion(String region)
		{
			this.region = region;
		}

		public String getResourceId() {
			return resourceId;
		}

		public void setResourceId(String resourceId) {
			this.resourceId = resourceId;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime
					* result
					+ ((accountResourceId == null) ? 0 : accountResourceId
							.hashCode());
			result = prime * result
					+ ((region == null) ? 0 : region.hashCode());
			result = prime * result
					+ ((resourceId == null) ? 0 : resourceId.hashCode());
			result = prime * result
					+ ((resourceType == null) ? 0 : resourceType.hashCode());
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			CloudResourceStorePK other = (CloudResourceStorePK) obj;
			if (accountResourceId == null) {
				if (other.accountResourceId != null)
					return false;
			} else if (!accountResourceId.equals(other.accountResourceId))
				return false;
			if (region == null) {
				if (other.region != null)
					return false;
			} else if (!region.equals(other.region))
				return false;
			if (resourceId == null) {
				if (other.resourceId != null)
					return false;
			} else if (!resourceId.equals(other.resourceId))
				return false;
			if (resourceType == null) {
				if (other.resourceType != null)
					return false;
			} else if (!resourceType.equals(other.resourceType))
				return false;
			return true;
		}

		@Override
		public String toString() {
			return "CloudResourceStorePK [resourceId=" + resourceId
					+ ", resourceType=" + resourceType + ", accountResourceId="
					+ accountResourceId + ", region=" + region + "]";
		}
	}
	
	private String resourceId;
	private String resourceType;
	private String cloudServiceId;
	private String accountResourceId;
	private String region;
	private String value;

	public CloudResourceStoreDao()
	{
	}

	public CloudResourceStoreDao(String resourceId, String resourceType, String cloudServiceId,
			String region, String accountResourceId, String value) {
		this.setResourceId(resourceId);
		this.resourceType = resourceType;
		this.cloudServiceId = cloudServiceId;
		this.accountResourceId = accountResourceId;
		this.region = region;
		this.value = value;
	}

	public CloudResourceStoreDao( CloudResourceStoreDao otherData )
	{
		setResourceId(otherData.getResourceId());
		setResourceType(otherData.getResourceType());
		setCloudServiceId(otherData.getCloudServiceId());
		setRegion(otherData.getRegion());
		setAccountResourceId(otherData.getAccountResourceId());
		setValue(otherData.getValue());
	}



	@Column(name="cloud_Service_id")
	public String getCloudServiceId() {
		return cloudServiceId;
	}

	public void setCloudServiceId(String cloudServiceId) {
		this.cloudServiceId = cloudServiceId;
	}
	
	@Id
	@Column(name="region")
	public String getRegion()
	{
		return this.region;
	}
	public void setRegion(String region)
	{
		this.region = region;
	}

	@Id
	@Column(name="account_resource_id")
	public String getAccountResourceId() {
		return accountResourceId;
	}
	public void setAccountResourceId(String AccountResourceId) {
		this.accountResourceId = AccountResourceId;
	}

	@Id
	@Column(name="resource_type")
	public String getResourceType() {
		return resourceType;
	}
	public void setResourceType(String resourceType) {
		this.resourceType = resourceType;
	}

	@Id
	@Column(name="resource_id")
	public String getResourceId() {
		return resourceId;
	}

	public void setResourceId(String resourceId) {
		this.resourceId = resourceId;
	}
	
	@Column(name="store_value")
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		this.value = value;
	}


	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CloudResourceStoreDao other = (CloudResourceStoreDao) obj;
		if (accountResourceId == null) {
			if (other.accountResourceId != null)
				return false;
		} else if (!accountResourceId.equals(other.accountResourceId))
			return false;
		if (cloudServiceId == null) {
			if (other.cloudServiceId != null)
				return false;
		} else if (!cloudServiceId.equals(other.cloudServiceId))
			return false;
		if (region == null) {
			if (other.region != null)
				return false;
		} else if (!region.equals(other.region))
			return false;
		if (resourceId == null) {
			if (other.resourceId != null)
				return false;
		} else if (!resourceId.equals(other.resourceId))
			return false;
		if (resourceType == null) {
			if (other.resourceType != null)
				return false;
		} else if (!resourceType.equals(other.resourceType))
			return false;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime
				* result
				+ ((accountResourceId == null) ? 0 : accountResourceId
						.hashCode());
		result = prime * result
				+ ((cloudServiceId == null) ? 0 : cloudServiceId.hashCode());
		result = prime * result + ((region == null) ? 0 : region.hashCode());
		result = prime * result
				+ ((resourceId == null) ? 0 : resourceId.hashCode());
		result = prime * result
				+ ((resourceType == null) ? 0 : resourceType.hashCode());
		result = prime * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}

	@Override
	public String toString() {
		return "CloudResourceStoreDao [resourceId=" + resourceId
				+ ", resourceType=" + resourceType + ", cloudServiceId="
				+ cloudServiceId + ", accountResourceId=" + accountResourceId
				+ ", region=" + region + ", value=" + value + "]";
	}
	
	@Override
	public CloudResourceStoreDao.CloudResourceStorePK getId() {
		return new CloudResourceStoreDao.CloudResourceStorePK(getResourceId(), getResourceType(), getRegion(), getAccountResourceId());
	}
}
