/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;

import com.clustercontrol.cloud.persistence.BooleanTFConverter;
import com.fasterxml.jackson.annotation.JsonBackReference;

//@JsonInclude(JsonInclude.Include.NON_NULL)
@Entity
public class ParameterDefinitionDao {
	private String name;
	private OperationDefinitionDao ownerOperation;
	private String displayName;
	private String description;
	private String pattern;
//	private String defaultValue;
	private boolean required;
	private boolean freeFormat;

	public ParameterDefinitionDao() {
		super();
	}

	@Id
	@Column
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	@JsonBackReference
    @ManyToOne
	@PrimaryKeyJoinColumn(name = "name")
	public OperationDefinitionDao getOwnerOperation() {
		return ownerOperation;
	}
	public void setOwnerOperation(OperationDefinitionDao ownerOperation) {
		this.ownerOperation = ownerOperation;
	}
	@Column
	public String getDisplayName() {
		return displayName;
	}
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}
	@Column
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	@Column
	public String getPattern() {
		return pattern;
	}
	public void setPattern(String pattern) {
		this.pattern = pattern;
	}
//	@Column
//	public String getDefaultValue() {
//		return defaultValue;
//	}
//	public void setDefaultValue(String defaultValue) {
//		this.defaultValue = defaultValue;
//	}
	@Column
	@Convert(converter=BooleanTFConverter.class)
	public boolean isRequired() {
		return required;
	}
	public void setRequired(boolean required) {
		this.required = required;
	}

	@Column
	@Convert(converter=BooleanTFConverter.class)
	public boolean isFreeFormat() {
		return freeFormat;
	}

	public void setFreeFormat(boolean freeFormat) {
		this.freeFormat = freeFormat;
	}
}
