/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.entity;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.jpasecurity.AccessManager;
import net.sf.jpasecurity.AccessType;
import net.sf.jpasecurity.SecureCollection;
import net.sf.jpasecurity.SecureEntity;
import net.sf.jpasecurity.entity.AbstractSecureObjectManager;
import net.sf.jpasecurity.entity.CollectionOperation;
import net.sf.jpasecurity.entity.SecureList;
import net.sf.jpasecurity.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSecureCollection<E, T extends Collection<E>>
extends AbstractCollection<E>
implements SecureCollection<E> {
    static final Object UNDEFINED = new Object();
    private final List<CollectionOperation<E, T>> operations = new ArrayList<CollectionOperation<E, T>>();
    private T original;
    private T filtered;
    private AbstractSecureObjectManager objectManager;
    private AccessManager accessManager;

    AbstractSecureCollection(T collection, AbstractSecureObjectManager objectManager, AccessManager accessManager) {
        this.original = collection;
        this.objectManager = objectManager;
        this.accessManager = accessManager;
    }

    AbstractSecureCollection(T original, T filtered, AbstractSecureObjectManager objectManager) {
        this(original, objectManager, (AccessManager)null);
        this.filtered = filtered;
    }

    @Override
    public Iterator<E> iterator() {
        return new FilteredIterator(this.getFiltered().iterator());
    }

    @Override
    public boolean add(final E entity) {
        this.addOperation(new CollectionOperation<E, T>(){

            @Override
            public void flush(T original, AbstractSecureObjectManager objectManager) {
                original.add((Object)objectManager.getUnsecureObject(entity));
            }
        });
        return this.getFiltered().add(entity);
    }

    @Override
    public boolean addAll(final Collection<? extends E> collection) {
        this.addOperation(new CollectionOperation<E, T>(){

            @Override
            public void flush(T original, AbstractSecureObjectManager objectManager) {
                if (collection instanceof AbstractSecureCollection) {
                    AbstractSecureCollection abstractSecureCollection = (AbstractSecureCollection)collection;
                    original.addAll(abstractSecureCollection.getOriginal());
                } else if (collection instanceof SecureList) {
                    original.addAll(((SecureList)collection).getOriginal());
                } else {
                    for (Object entry : collection) {
                        original.add(objectManager.getUnsecureObject(entry));
                    }
                }
            }
        });
        return this.getFiltered().addAll(collection);
    }

    @Override
    public boolean remove(final Object entity) {
        this.addOperation(new CollectionOperation<E, T>(){

            @Override
            public void flush(T original, AbstractSecureObjectManager objectManager) {
                original.remove(objectManager.getUnsecureObject(entity));
            }
        });
        return this.getFiltered().remove(entity);
    }

    @Override
    public boolean removeAll(final Collection<?> collection) {
        this.addOperation(new CollectionOperation<E, T>(){

            @Override
            public void flush(T original, AbstractSecureObjectManager objectManager) {
                if (collection instanceof AbstractSecureCollection) {
                    original.removeAll((Collection<?>)((AbstractSecureCollection)collection).getOriginal());
                } else if (collection instanceof SecureList) {
                    original.removeAll(((SecureList)collection).getOriginal());
                } else {
                    for (Object entry : collection) {
                        original.remove(objectManager.getUnsecureObject(entry));
                    }
                }
            }
        });
        return this.getFiltered().removeAll(collection);
    }

    @Override
    public boolean retainAll(final Collection<?> collection) {
        this.addOperation(new CollectionOperation<E, T>(){

            @Override
            public void flush(T original, AbstractSecureObjectManager objectManager) {
                if (collection instanceof AbstractSecureCollection) {
                    original.retainAll((Collection<?>)((AbstractSecureCollection)collection).getOriginal());
                } else if (collection instanceof SecureList) {
                    original.retainAll(((SecureList)collection).getOriginal());
                } else {
                    ArrayList list = new ArrayList();
                    for (Object entry : collection) {
                        list.add(AbstractSecureCollection.this.getObjectManager().getUnsecureObject(entry));
                    }
                    original.retainAll(list);
                }
            }
        });
        return this.getFiltered().retainAll(collection);
    }

    @Override
    public SecureCollection<E> merge(SecureCollection<E> secureCollection) {
        if (!(secureCollection instanceof AbstractSecureCollection)) {
            throw new IllegalArgumentException("cannot merge collection of type " + secureCollection.getClass().getName());
        }
        ((AbstractSecureCollection)secureCollection).operations.addAll(this.operations);
        return secureCollection;
    }

    @Override
    public void clear() {
        this.addOperation(new CollectionOperation<E, T>(){

            @Override
            public void flush(T original, AbstractSecureObjectManager objectManager) {
                original.clear();
            }
        });
        this.getFiltered().clear();
    }

    @Override
    public int size() {
        return this.getFiltered().size();
    }

    final void addOperation(CollectionOperation<E, T> operation) {
        this.operations.add(operation);
    }

    final AbstractSecureObjectManager getObjectManager() {
        return this.objectManager;
    }

    final T getOriginal() {
        return this.original;
    }

    final T getFiltered() {
        this.checkInitialized();
        return this.filtered;
    }

    abstract T createFiltered();

    boolean isReadable(Object entity) {
        return this.accessManager.isAccessible(AccessType.READ, entity);
    }

    @Override
    public boolean isInitialized() {
        return this.filtered != null;
    }

    @Override
    public boolean isDirty() {
        return !this.operations.isEmpty();
    }

    public void flush() {
        for (CollectionOperation<T, T> collectionOperation : this.operations) {
            collectionOperation.flush(this.getOriginal(), this.getObjectManager());
        }
        this.operations.clear();
    }

    void checkInitialized() {
        if (!this.isInitialized()) {
            this.initialize(true);
        }
    }

    void initialize(boolean checkAccess) {
        this.filtered = this.createFiltered();
        for (Object entity : this.original) {
            if (Types.isSimplePropertyType(entity.getClass())) {
                this.filtered.add(entity);
            }
            if (checkAccess && !this.isReadable(entity)) continue;
            Object secureEntity = this.objectManager.getSecureObject(entity);
            if (secureEntity instanceof SecureEntity) {
                this.objectManager.initialize((SecureEntity)secureEntity, checkAccess);
            }
            this.filtered.add(secureEntity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FilteredIterator
    implements Iterator<E> {
        Iterator<E> iterator;
        E current = UNDEFINED;

        public FilteredIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == UNDEFINED) {
                throw new IllegalStateException();
            }
            this.checkRange(this.current);
            this.iterator.remove();
            AbstractSecureCollection.this.remove(this.current);
            this.current = UNDEFINED;
        }

        protected void checkRange(E entry) {
        }
    }
}

