/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.entity;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jpasecurity.AccessManager;
import net.sf.jpasecurity.AccessType;
import net.sf.jpasecurity.SecureEntity;
import net.sf.jpasecurity.SecureMap;
import net.sf.jpasecurity.entity.AbstractSecureObjectManager;
import net.sf.jpasecurity.entity.MapOperation;
import net.sf.jpasecurity.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSecureMap<K, V>
extends AbstractMap<K, V>
implements SecureMap<K, V> {
    private final List<MapOperation<K, V>> operations = new ArrayList<MapOperation<K, V>>();
    private final SecureEntrySet entrySet = new SecureEntrySet();
    private Map<K, V> original;
    private Map<K, V> filtered;
    private AbstractSecureObjectManager objectManager;
    private AccessManager accessManager;

    DefaultSecureMap(Map<K, V> original, AbstractSecureObjectManager objectManager, AccessManager accessManager) {
        this.original = original;
        this.objectManager = objectManager;
        this.accessManager = accessManager;
    }

    DefaultSecureMap(Map<K, V> original, Map<K, V> filtered, AbstractSecureObjectManager objectManager) {
        this(original, objectManager, null);
        this.filtered = filtered;
    }

    @Override
    public void clear() {
        this.addOperation(new MapOperation<K, V>(){

            @Override
            public void flush(Map<K, V> original, AbstractSecureObjectManager objectManager) {
                original.clear();
            }
        });
        this.getFiltered().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getFiltered().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getFiltered().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.getFiltered().get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getFiltered().isEmpty();
    }

    @Override
    public V put(final K key, final V value) {
        this.addOperation(new MapOperation<K, V>(){

            @Override
            public void flush(Map<K, V> original, AbstractSecureObjectManager objectManager) {
                original.put(DefaultSecureMap.this.getUnsecureKey(key, objectManager), objectManager.getUnsecureObject(value));
            }
        });
        return this.getFiltered().put(key, value);
    }

    @Override
    public void putAll(final Map<? extends K, ? extends V> map) {
        this.addOperation(new MapOperation<K, V>(){

            @Override
            public void flush(Map<K, V> original, AbstractSecureObjectManager objectManager) {
                if (map instanceof DefaultSecureMap) {
                    original.putAll(((DefaultSecureMap)map).original);
                } else {
                    for (Map.Entry entry : map.entrySet()) {
                        original.put(DefaultSecureMap.this.getUnsecureKey(entry.getKey(), objectManager), objectManager.getUnsecureObject(entry.getValue()));
                    }
                }
            }
        });
        this.getFiltered().putAll(map);
    }

    @Override
    public V remove(final Object key) {
        this.addOperation(new MapOperation<K, V>(){

            @Override
            public void flush(Map<K, V> original, AbstractSecureObjectManager objectManager) {
                original.remove(DefaultSecureMap.this.getUnsecureKey(key, objectManager));
            }
        });
        return this.getFiltered().remove(key);
    }

    @Override
    public int size() {
        return this.getFiltered().size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public boolean isInitialized() {
        return this.filtered != null;
    }

    @Override
    public boolean isDirty() {
        return !this.operations.isEmpty();
    }

    @Override
    public SecureMap<K, V> merge(SecureMap<K, V> secureMap) {
        if (!(secureMap instanceof DefaultSecureMap)) {
            throw new IllegalArgumentException("cannot merge map of type " + secureMap.getClass().getName());
        }
        ((DefaultSecureMap)secureMap).operations.addAll(this.operations);
        return secureMap;
    }

    public void flush() {
        for (MapOperation<K, V> operation : this.operations) {
            operation.flush(this.original, this.objectManager);
        }
        this.operations.clear();
    }

    Map<K, V> getFiltered() {
        this.checkInitialized();
        return this.filtered;
    }

    Map<K, V> getOriginal() {
        return this.original;
    }

    private <T> T getUnsecureKey(T key, AbstractSecureObjectManager objectManager) {
        return Types.isSimplePropertyType(key.getClass()) ? key : objectManager.getUnsecureObject(key);
    }

    void checkInitialized() {
        if (!this.isInitialized()) {
            this.initialize(true);
        }
    }

    void initialize(boolean checkAccess) {
        this.filtered = new LinkedHashMap();
        for (Map.Entry<K, V> entry : this.original.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            Object secureKey = null;
            Object secureValue = null;
            boolean filteredOut = false;
            if (Types.isSimplePropertyType(key.getClass())) {
                secureKey = key;
            } else if (!checkAccess || this.isReadable(key)) {
                secureKey = this.objectManager.getSecureObject(key);
                if (secureKey instanceof SecureEntity) {
                    this.objectManager.initialize((SecureEntity)secureKey, checkAccess);
                }
            } else {
                filteredOut = true;
            }
            if (Types.isSimplePropertyType(value.getClass())) {
                secureValue = value;
            } else if (!checkAccess || this.isReadable(value)) {
                secureValue = this.objectManager.getSecureObject(value);
                if (secureValue instanceof SecureEntity) {
                    this.objectManager.initialize((SecureEntity)secureValue, checkAccess);
                }
            } else {
                filteredOut = true;
            }
            if (filteredOut) continue;
            this.filtered.put(secureKey, secureValue);
        }
    }

    private boolean isReadable(Object entity) {
        return this.accessManager.isAccessible(AccessType.READ, entity);
    }

    private void addOperation(MapOperation<K, V> operation) {
        this.operations.add(operation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteredEntry
    implements Map.Entry<K, V> {
        private Map.Entry<K, V> entry;

        public FilteredEntry(Map.Entry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(final V value) {
            DefaultSecureMap.this.addOperation(new MapOperation<K, V>(){

                @Override
                public void flush(Map<K, V> original, AbstractSecureObjectManager objectManager) {
                    original.put(DefaultSecureMap.this.getUnsecureKey(FilteredEntry.this.entry.getKey(), objectManager), objectManager.getUnsecureObject(value));
                }
            });
            return this.entry.setValue(value);
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.getKey() == entry.getKey() || this.getKey() != null && this.getKey().equals(entry.getKey())) && (this.getValue() == entry.getValue() || this.getValue() != null && this.getValue().equals(entry.getValue()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteredEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, V>> iterator;
        private Map.Entry<K, V> current;

        private FilteredEntryIterator() {
            this.iterator = DefaultSecureMap.this.getFiltered().entrySet().iterator();
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iterator.next();
            return new FilteredEntry(this.current);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.iterator.remove();
            DefaultSecureMap.this.remove(this.current.getKey());
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SecureEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private SecureEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new FilteredEntryIterator();
        }

        @Override
        public boolean remove(Object object) {
            Object oldValue;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (DefaultSecureMap.this.containsKey(entry.getKey()) && (oldValue = DefaultSecureMap.this.get(entry.getKey())) != entry.getValue() && (oldValue == null || !oldValue.equals(entry.getValue()))) {
                return false;
            }
            oldValue = DefaultSecureMap.this.remove(entry.getKey());
            return oldValue == null ? entry.getValue() != null : !oldValue.equals(entry.getValue());
        }

        @Override
        public int size() {
            return DefaultSecureMap.this.size();
        }
    }
}

