/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.entity;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jpasecurity.AccessManager;
import net.sf.jpasecurity.entity.AbstractSecureCollection;
import net.sf.jpasecurity.entity.AbstractSecureObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureSortedSet<E>
extends AbstractSecureCollection<E, SortedSet<E>>
implements SortedSet<E> {
    public SecureSortedSet(SortedSet<E> set, AbstractSecureObjectManager objectManager, AccessManager accessManager) {
        super(set, objectManager, accessManager);
    }

    SecureSortedSet(SortedSet<E> original, SortedSet<E> filtered, AbstractSecureObjectManager objectManager) {
        super(original, filtered, objectManager);
    }

    @Override
    protected SortedSet<E> createFiltered() {
        if (((SortedSet)this.getOriginal()).comparator() == null) {
            return new TreeSet();
        }
        return new TreeSet(((SortedSet)this.getOriginal()).comparator());
    }

    @Override
    public Comparator<? super E> comparator() {
        return ((SortedSet)this.getFiltered()).comparator();
    }

    @Override
    public E first() {
        return ((SortedSet)this.getFiltered()).first();
    }

    @Override
    public E last() {
        return ((SortedSet)this.getFiltered()).last();
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return new SecureSubSet(this.first(), toElement);
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return new SecureSubSet(fromElement, toElement);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return new SecureSubSet(fromElement, this.last(), true);
    }

    private int compare(E object1, E object2) {
        if (this.comparator() != null) {
            return this.comparator().compare(object1, object2);
        }
        Comparable comparable1 = (Comparable)object1;
        return comparable1.compareTo(object2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SecureSubSet
    extends AbstractSet<E>
    implements SortedSet<E> {
        private E from;
        private E to;
        boolean tailSet = false;

        public SecureSubSet(E from, E to) {
            this(from, to, false);
        }

        public SecureSubSet(E from, E to, boolean tailSet) {
            this.from = from;
            this.to = to;
            this.tailSet = tailSet;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.tailSet) {
                return new SecureSubSetIterator(((SortedSet)SecureSortedSet.this.getFiltered()).tailSet(this.from).iterator());
            }
            return new SecureSubSetIterator(((SortedSet)SecureSortedSet.this.getFiltered()).subSet(this.from, this.to).iterator());
        }

        @Override
        public boolean add(E entry) {
            this.checkRange(entry);
            return SecureSortedSet.this.add(entry);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            for (Object entry : collection) {
                this.checkRange(entry);
            }
            return SecureSortedSet.this.addAll(collection);
        }

        @Override
        public boolean remove(Object entry) {
            this.checkRange(entry);
            return SecureSortedSet.this.remove(entry);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            for (Object entry : collection) {
                this.checkRange(entry);
            }
            return SecureSortedSet.this.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            for (Object entry : collection) {
                this.checkRange(entry);
            }
            return SecureSortedSet.this.retainAll(collection);
        }

        @Override
        public void clear() {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        @Override
        public int size() {
            if (this.tailSet) {
                return ((SortedSet)SecureSortedSet.this.getFiltered()).tailSet(this.from).size();
            }
            return ((SortedSet)SecureSortedSet.this.getFiltered()).subSet(this.from, this.to).size();
        }

        @Override
        public Comparator<? super E> comparator() {
            return SecureSortedSet.this.comparator();
        }

        @Override
        public E first() {
            return ((SortedSet)SecureSortedSet.this.getFiltered()).subSet(this.from, this.to).first();
        }

        @Override
        public E last() {
            if (this.tailSet) {
                return ((SortedSet)SecureSortedSet.this.getFiltered()).tailSet(this.from).last();
            }
            return ((SortedSet)SecureSortedSet.this.getFiltered()).subSet(this.from, this.to).last();
        }

        @Override
        public SortedSet<E> headSet(E to) {
            this.checkRange(to);
            return new SecureSubSet(this.from, to);
        }

        @Override
        public SortedSet<E> subSet(E from, E to) {
            this.checkRange(from);
            this.checkRange(to);
            return new SecureSubSet(from, to);
        }

        @Override
        public SortedSet<E> tailSet(E from) {
            this.checkRange(from);
            return new SecureSubSet(from, this.to, true);
        }

        protected void checkRange(E entry) {
            if (SecureSortedSet.this.compare(this.from, entry) > 0 || SecureSortedSet.this.compare(entry, this.to) > 0 || !this.tailSet && SecureSortedSet.this.compare(entry, this.to) == 0) {
                throw new IllegalArgumentException("entry out of range");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SecureSubSetIterator
        extends AbstractSecureCollection.FilteredIterator {
            public SecureSubSetIterator(Iterator<E> iterator) {
                super(iterator);
            }

            @Override
            protected void checkRange(E entry) {
                SecureSubSet.this.checkRange(entry);
            }
        }
    }
}

