/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.jpql.compiler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.jpql.JpqlCompiledStatement;
import net.sf.jpasecurity.jpql.compiler.JpqlCompiler;
import net.sf.jpasecurity.jpql.compiler.MappedPathEvaluator;
import net.sf.jpasecurity.jpql.compiler.NotEvaluatableException;
import net.sf.jpasecurity.jpql.compiler.QueryEvaluationParameters;
import net.sf.jpasecurity.jpql.compiler.SubselectEvaluator;
import net.sf.jpasecurity.jpql.parser.JpqlAbs;
import net.sf.jpasecurity.jpql.parser.JpqlAdd;
import net.sf.jpasecurity.jpql.parser.JpqlAnd;
import net.sf.jpasecurity.jpql.parser.JpqlBetween;
import net.sf.jpasecurity.jpql.parser.JpqlBooleanLiteral;
import net.sf.jpasecurity.jpql.parser.JpqlBrackets;
import net.sf.jpasecurity.jpql.parser.JpqlCollectionValuedPath;
import net.sf.jpasecurity.jpql.parser.JpqlConcat;
import net.sf.jpasecurity.jpql.parser.JpqlCurrentDate;
import net.sf.jpasecurity.jpql.parser.JpqlCurrentTime;
import net.sf.jpasecurity.jpql.parser.JpqlCurrentTimestamp;
import net.sf.jpasecurity.jpql.parser.JpqlDecimalLiteral;
import net.sf.jpasecurity.jpql.parser.JpqlDivide;
import net.sf.jpasecurity.jpql.parser.JpqlEquals;
import net.sf.jpasecurity.jpql.parser.JpqlEscapeCharacter;
import net.sf.jpasecurity.jpql.parser.JpqlExists;
import net.sf.jpasecurity.jpql.parser.JpqlFrom;
import net.sf.jpasecurity.jpql.parser.JpqlGreaterOrEquals;
import net.sf.jpasecurity.jpql.parser.JpqlGreaterThan;
import net.sf.jpasecurity.jpql.parser.JpqlGroupBy;
import net.sf.jpasecurity.jpql.parser.JpqlHaving;
import net.sf.jpasecurity.jpql.parser.JpqlIdentificationVariable;
import net.sf.jpasecurity.jpql.parser.JpqlIdentifier;
import net.sf.jpasecurity.jpql.parser.JpqlIn;
import net.sf.jpasecurity.jpql.parser.JpqlIntegerLiteral;
import net.sf.jpasecurity.jpql.parser.JpqlIsEmpty;
import net.sf.jpasecurity.jpql.parser.JpqlIsNull;
import net.sf.jpasecurity.jpql.parser.JpqlLength;
import net.sf.jpasecurity.jpql.parser.JpqlLessOrEquals;
import net.sf.jpasecurity.jpql.parser.JpqlLessThan;
import net.sf.jpasecurity.jpql.parser.JpqlLike;
import net.sf.jpasecurity.jpql.parser.JpqlLocate;
import net.sf.jpasecurity.jpql.parser.JpqlLower;
import net.sf.jpasecurity.jpql.parser.JpqlMemberOf;
import net.sf.jpasecurity.jpql.parser.JpqlMod;
import net.sf.jpasecurity.jpql.parser.JpqlMultiply;
import net.sf.jpasecurity.jpql.parser.JpqlNamedInputParameter;
import net.sf.jpasecurity.jpql.parser.JpqlNegative;
import net.sf.jpasecurity.jpql.parser.JpqlNot;
import net.sf.jpasecurity.jpql.parser.JpqlNotEquals;
import net.sf.jpasecurity.jpql.parser.JpqlOr;
import net.sf.jpasecurity.jpql.parser.JpqlOrderBy;
import net.sf.jpasecurity.jpql.parser.JpqlPath;
import net.sf.jpasecurity.jpql.parser.JpqlPositionalInputParameter;
import net.sf.jpasecurity.jpql.parser.JpqlSelectClause;
import net.sf.jpasecurity.jpql.parser.JpqlSize;
import net.sf.jpasecurity.jpql.parser.JpqlSqrt;
import net.sf.jpasecurity.jpql.parser.JpqlStringLiteral;
import net.sf.jpasecurity.jpql.parser.JpqlSubselect;
import net.sf.jpasecurity.jpql.parser.JpqlSubstring;
import net.sf.jpasecurity.jpql.parser.JpqlSubtract;
import net.sf.jpasecurity.jpql.parser.JpqlTrim;
import net.sf.jpasecurity.jpql.parser.JpqlTrimBoth;
import net.sf.jpasecurity.jpql.parser.JpqlTrimCharacter;
import net.sf.jpasecurity.jpql.parser.JpqlTrimLeading;
import net.sf.jpasecurity.jpql.parser.JpqlTrimTrailing;
import net.sf.jpasecurity.jpql.parser.JpqlUpper;
import net.sf.jpasecurity.jpql.parser.JpqlVisitorAdapter;
import net.sf.jpasecurity.jpql.parser.Node;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEvaluator
extends JpqlVisitorAdapter<QueryEvaluationParameters> {
    public static final int DECIMAL_PRECISION = 100;
    public static final RoundingMode ROUNDING_MODE = RoundingMode.HALF_UP;
    private final JpqlCompiler compiler;
    private final ExceptionFactory exceptionFactory;
    private final SubselectEvaluator[] subselectEvaluators;

    public QueryEvaluator(JpqlCompiler compiler, ExceptionFactory exceptionFactory, SubselectEvaluator ... subselectEvaluators) {
        if (compiler == null) {
            throw new IllegalArgumentException("compiler may not be null");
        }
        if (exceptionFactory == null) {
            throw new IllegalArgumentException("exceptionFactory may not be null");
        }
        this.compiler = compiler;
        this.exceptionFactory = exceptionFactory;
        this.subselectEvaluators = subselectEvaluators;
        for (SubselectEvaluator subselectEvaluator : subselectEvaluators) {
            subselectEvaluator.setQueryEvaluator(this);
        }
    }

    public boolean canEvaluate(Node node, QueryEvaluationParameters parameters) {
        try {
            this.evaluate(node, parameters);
            return true;
        }
        catch (NotEvaluatableException e) {
            return false;
        }
    }

    public <R> R evaluate(Node node, QueryEvaluationParameters parameters) throws NotEvaluatableException {
        node.visit(this, parameters);
        return (R)parameters.getResult();
    }

    @Override
    public boolean visit(JpqlSelectClause node, QueryEvaluationParameters data) {
        data.setResultUndefined();
        return false;
    }

    @Override
    public boolean visit(JpqlFrom node, QueryEvaluationParameters data) {
        data.setResultUndefined();
        return false;
    }

    @Override
    public boolean visit(JpqlGroupBy node, QueryEvaluationParameters data) {
        data.setResultUndefined();
        return false;
    }

    @Override
    public boolean visit(JpqlHaving node, QueryEvaluationParameters data) {
        data.setResultUndefined();
        return false;
    }

    @Override
    public boolean visit(JpqlOrderBy node, QueryEvaluationParameters data) {
        data.setResultUndefined();
        return false;
    }

    @Override
    public boolean visit(JpqlPath node, QueryEvaluationParameters data) {
        try {
            node.jjtGetChild(0).visit(this, data);
            Path path = new Path(node.toString());
            if (path.hasSubpath()) {
                MappedPathEvaluator pathEvaluator = new MappedPathEvaluator(data.getMappingInformation(), this.exceptionFactory);
                data.setResult(pathEvaluator.evaluate(data.getResult(), path.getSubpath()));
            }
        }
        catch (NotEvaluatableException e) {
            data.setResultUndefined();
        }
        return false;
    }

    @Override
    public boolean visit(JpqlCollectionValuedPath node, QueryEvaluationParameters data) {
        try {
            node.jjtGetChild(0).visit(this, data);
            String path = node.toString();
            int index = path.indexOf(46);
            if (index != -1) {
                MappedPathEvaluator pathEvaluator = new MappedPathEvaluator(data.getMappingInformation(), this.exceptionFactory);
                Set rootCollection = Collections.singleton(data.getResult());
                data.setResult(pathEvaluator.evaluateAll(rootCollection, path.substring(index + 1)));
            }
        }
        catch (NotEvaluatableException e) {
            data.setResultUndefined();
        }
        return false;
    }

    @Override
    public boolean visit(JpqlOr node, QueryEvaluationParameters data) {
        boolean undefined = false;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).visit(this, data);
            try {
                if (!((Boolean)data.getResult()).booleanValue()) continue;
                return false;
            }
            catch (NotEvaluatableException e) {
                undefined = true;
            }
        }
        if (undefined) {
            data.setResultUndefined();
        } else {
            data.setResult(Boolean.FALSE);
        }
        return false;
    }

    @Override
    public boolean visit(JpqlAnd node, QueryEvaluationParameters data) {
        boolean undefined = false;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).visit(this, data);
            try {
                if (((Boolean)data.getResult()).booleanValue()) continue;
                return false;
            }
            catch (NotEvaluatableException e) {
                undefined = true;
            }
        }
        if (undefined) {
            data.setResultUndefined();
        } else {
            data.setResult(Boolean.TRUE);
        }
        return false;
    }

    @Override
    public boolean visit(JpqlNot node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 1);
        node.jjtGetChild(0).visit(this, data);
        try {
            data.setResult((Boolean)data.getResult() == false);
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlBetween node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 3);
        try {
            Comparable upper;
            Comparable lower;
            node.jjtGetChild(0).visit(this, data);
            Comparable value = (Comparable)data.getResult();
            node.jjtGetChild(1).visit(this, data);
            try {
                lower = (Comparable)data.getResult();
            }
            catch (NotEvaluatableException e) {
                lower = null;
            }
            node.jjtGetChild(2).visit(this, data);
            try {
                upper = (Comparable)data.getResult();
            }
            catch (NotEvaluatableException e) {
                upper = null;
            }
            if (lower != null && lower.compareTo(value) > 0 || upper != null && upper.compareTo(value) < 0) {
                data.setResult(false);
            } else if (lower == null || upper == null) {
                data.setResultUndefined();
            } else {
                data.setResult(true);
            }
        }
        catch (ClassCastException e) {
            data.setResultUndefined();
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlIn node, QueryEvaluationParameters data) {
        Object value;
        try {
            node.jjtGetChild(0).visit(this, data);
            value = data.getResult();
        }
        catch (NotEvaluatableException e) {
            data.setResultUndefined();
            return false;
        }
        boolean undefined = false;
        ArrayList values = new ArrayList();
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).visit(this, data);
            try {
                if (data.getResult() instanceof Collection) {
                    values.addAll((Collection)data.getResult());
                    continue;
                }
                values.add(data.getResult());
                continue;
            }
            catch (NotEvaluatableException e) {
                undefined = true;
            }
        }
        if (values.contains(value)) {
            data.setResult(Boolean.TRUE);
        } else if (undefined) {
            data.setResultUndefined();
        } else {
            data.setResult(Boolean.FALSE);
        }
        return false;
    }

    @Override
    public boolean visit(JpqlLike node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            String text = (String)data.getResult();
            node.jjtGetChild(1).visit(this, data);
            String pattern = (String)data.getResult();
            data.setResult(text.matches(this.createRegularExpression(pattern)));
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    private String createRegularExpression(String pattern) {
        StringBuilder regularExpressionBuilder = new StringBuilder();
        int index = 0;
        int specialCharacterIndex = this.indexOfSpecialCharacter(pattern, index);
        this.appendSubPattern(regularExpressionBuilder, pattern, index, specialCharacterIndex);
        while (specialCharacterIndex < pattern.length()) {
            index = specialCharacterIndex;
            if (pattern.charAt(index) == '\\') {
                ++index;
            }
            if (pattern.charAt(index) == '_') {
                regularExpressionBuilder.append('.');
                ++index;
            } else if (pattern.charAt(index) == '%') {
                regularExpressionBuilder.append(".*");
                ++index;
            } else {
                throw new IllegalStateException();
            }
            specialCharacterIndex = this.indexOfSpecialCharacter(pattern, index);
            this.appendSubPattern(regularExpressionBuilder, pattern, index, specialCharacterIndex);
        }
        return regularExpressionBuilder.toString();
    }

    private int indexOfSpecialCharacter(String pattern, int startIndex) {
        int i1 = pattern.indexOf("\\_", startIndex);
        int i2 = pattern.indexOf("_", startIndex);
        int i3 = pattern.indexOf("\\%", startIndex);
        int i4 = pattern.indexOf("%", startIndex);
        int min = pattern.length();
        if (i1 > -1 && i1 < min) {
            min = i1;
        }
        if (i2 > -1 && i2 < min) {
            min = i2;
        }
        if (i3 > -1 && i3 < min) {
            min = i3;
        }
        if (i4 > -1 && i4 < min) {
            min = i4;
        }
        return min;
    }

    private void appendSubPattern(StringBuilder regularExpression, String pattern, int startIndex, int endIndex) {
        String subpattern = pattern.substring(startIndex, endIndex);
        if (subpattern.length() > 0) {
            regularExpression.append("\\Q").append(subpattern).append("\\E");
        }
    }

    @Override
    public boolean visit(JpqlIsNull node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 1);
        try {
            node.jjtGetChild(0).visit(this, data);
            data.setResult(data.getResult() == null);
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlIsEmpty node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 1);
        try {
            node.jjtGetChild(0).visit(this, data);
            Collection result = (Collection)data.getResult();
            data.setResult(result == null || result.isEmpty());
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlMemberOf node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            Object value = data.getResult();
            node.jjtGetChild(1).visit(this, data);
            data.setResult(((Collection)data.getResult()).contains(value));
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlEquals node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            Object value1 = this.convert(data.getResult());
            if (value1 == null) {
                data.setResult(false);
            } else {
                node.jjtGetChild(1).visit(this, data);
                Object value2 = this.convert(data.getResult());
                data.setResult(value1.equals(value2));
            }
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlNotEquals node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            Object value1 = data.getResult();
            node.jjtGetChild(1).visit(this, data);
            Object value2 = data.getResult();
            data.setResult(!value1.equals(value2));
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlGreaterThan node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            Comparable value1 = (Comparable)data.getResult();
            node.jjtGetChild(1).visit(this, data);
            Comparable value2 = (Comparable)data.getResult();
            data.setResult(value1.compareTo(value2) > 0);
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlGreaterOrEquals node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            Comparable value1 = (Comparable)data.getResult();
            node.jjtGetChild(1).visit(this, data);
            Comparable value2 = (Comparable)data.getResult();
            data.setResult(value1.compareTo(value2) >= 0);
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlLessThan node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            Comparable value1 = (Comparable)data.getResult();
            node.jjtGetChild(1).visit(this, data);
            Comparable value2 = (Comparable)data.getResult();
            data.setResult(value1.compareTo(value2) < 0);
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlLessOrEquals node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            Comparable value1 = (Comparable)data.getResult();
            node.jjtGetChild(1).visit(this, data);
            Comparable value2 = (Comparable)data.getResult();
            data.setResult(value1.compareTo(value2) <= 0);
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlAdd node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            BigDecimal value1 = new BigDecimal(data.getResult().toString());
            node.jjtGetChild(1).visit(this, data);
            BigDecimal value2 = new BigDecimal(data.getResult().toString());
            data.setResult(value1.add(value2));
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlSubtract node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            BigDecimal value1 = new BigDecimal(data.getResult().toString());
            node.jjtGetChild(1).visit(this, data);
            BigDecimal value2 = new BigDecimal(data.getResult().toString());
            data.setResult(value1.subtract(value2));
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlMultiply node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            BigDecimal value1 = new BigDecimal(data.getResult().toString());
            node.jjtGetChild(1).visit(this, data);
            BigDecimal value2 = new BigDecimal(data.getResult().toString());
            data.setResult(value1.multiply(value2));
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlDivide node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            BigDecimal value1 = new BigDecimal(data.getResult().toString());
            node.jjtGetChild(1).visit(this, data);
            BigDecimal value2 = new BigDecimal(data.getResult().toString());
            data.setResult(value1.divide(value2, 100, ROUNDING_MODE));
        }
        catch (ArithmeticException e) {
            data.setResultUndefined();
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlNegative node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 1);
        try {
            node.jjtGetChild(0).visit(this, data);
            BigDecimal value = new BigDecimal(data.getResult().toString());
            data.setResult(value.negate());
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlConcat node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            String value1 = (String)data.getResult();
            node.jjtGetChild(1).visit(this, data);
            String value2 = (String)data.getResult();
            data.setResult(value1 + value2);
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlSubstring node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 3);
        try {
            node.jjtGetChild(0).visit(this, data);
            String text = (String)data.getResult();
            node.jjtGetChild(1).visit(this, data);
            int fromIndex = new BigDecimal(data.getResult().toString()).intValue();
            node.jjtGetChild(2).visit(this, data);
            int toIndex = new BigDecimal(data.getResult().toString()).intValue();
            data.setResult(text.substring(fromIndex, toIndex));
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlTrim node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 1, 3);
        try {
            boolean leading = true;
            boolean trailing = true;
            boolean trimSpecificationPresent = false;
            if (node.jjtGetChild(0) instanceof JpqlTrimLeading) {
                trailing = false;
                trimSpecificationPresent = true;
            } else if (node.jjtGetChild(0) instanceof JpqlTrimTrailing) {
                leading = false;
                trimSpecificationPresent = true;
            } else if (node.jjtGetChild(0) instanceof JpqlTrimBoth) {
                trimSpecificationPresent = true;
            }
            char trimCharacter = ' ';
            if (trimSpecificationPresent && node.jjtGetNumChildren() == 3) {
                node.jjtGetChild(1).visit(this, data);
                trimCharacter = ((String)data.getResult()).charAt(0);
            } else if (!trimSpecificationPresent && node.jjtGetNumChildren() == 2) {
                node.jjtGetChild(0).visit(this, data);
                trimCharacter = ((String)data.getResult()).charAt(0);
            }
            node.jjtGetChild(node.jjtGetNumChildren() - 1).visit(this, data);
            String text = (String)data.getResult();
            StringBuilder builder = new StringBuilder(text);
            if (leading) {
                while (builder.charAt(0) == trimCharacter) {
                    builder.deleteCharAt(0);
                }
            }
            if (trailing) {
                while (builder.charAt(builder.length() - 1) == trimCharacter) {
                    builder.deleteCharAt(builder.length() - 1);
                }
            }
            data.setResult(builder.toString());
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlLower node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 1);
        try {
            node.jjtGetChild(0).visit(this, data);
            data.setResult(data.getResult().toString().toLowerCase());
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlUpper node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 1);
        try {
            node.jjtGetChild(0).visit(this, data);
            data.setResult(data.getResult().toString().toUpperCase());
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlLength node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 1);
        try {
            node.jjtGetChild(0).visit(this, data);
            data.setResult(data.getResult().toString().length());
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlLocate node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2, 3);
        try {
            node.jjtGetChild(0).visit(this, data);
            String text = data.getResult().toString();
            node.jjtGetChild(1).visit(this, data);
            String substring = data.getResult().toString();
            int start = 0;
            if (node.jjtGetNumChildren() == 3) {
                node.jjtGetChild(2).visit(this, data);
                start = new BigInteger(data.getResult().toString()).intValue();
            }
            data.setResult(text.indexOf(substring, start));
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlAbs node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 1);
        try {
            node.jjtGetChild(0).visit(this, data);
            data.setResult(new BigDecimal(data.getResult().toString()).abs());
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlSqrt node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 1);
        try {
            node.jjtGetChild(0).visit(this, data);
            data.setResult(Math.sqrt(new BigDecimal(data.getResult().toString()).doubleValue()));
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlMod node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 2);
        try {
            node.jjtGetChild(0).visit(this, data);
            int i1 = Integer.parseInt(data.getResult().toString());
            node.jjtGetChild(1).visit(this, data);
            int i2 = Integer.parseInt(data.getResult().toString());
            data.setResult(i1 % i2);
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlSize node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 1);
        try {
            node.jjtGetChild(0).visit(this, data);
            data.setResult(((Collection)data.getResult()).size());
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlBrackets node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 1);
        node.jjtGetChild(0).visit(this, data);
        return false;
    }

    @Override
    public boolean visit(JpqlCurrentDate node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        data.setResult(new Date(new java.util.Date().getTime()));
        return false;
    }

    @Override
    public boolean visit(JpqlCurrentTime node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        data.setResult(new Time(new java.util.Date().getTime()));
        return false;
    }

    @Override
    public boolean visit(JpqlCurrentTimestamp node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        data.setResult(new Timestamp(new java.util.Date().getTime()));
        return false;
    }

    @Override
    public boolean visit(JpqlIdentifier node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        try {
            data.setResult(data.getAliasValue(new Alias(node.getValue())));
        }
        catch (NotEvaluatableException e) {
            data.setResultUndefined();
        }
        return false;
    }

    @Override
    public boolean visit(JpqlIdentificationVariable node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        try {
            data.setResult(data.getAliasValue(new Alias(node.getValue())));
        }
        catch (NotEvaluatableException e) {
            data.setResultUndefined();
        }
        return false;
    }

    @Override
    public boolean visit(JpqlIntegerLiteral node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        data.setResult(new BigDecimal(node.getValue()));
        return false;
    }

    @Override
    public boolean visit(JpqlDecimalLiteral node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        data.setResult(new BigDecimal(node.getValue()));
        return false;
    }

    @Override
    public boolean visit(JpqlBooleanLiteral node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        data.setResult(Boolean.valueOf(node.getValue()));
        return false;
    }

    @Override
    public boolean visit(JpqlStringLiteral node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        data.setResult(node.getValue().substring(1, node.getValue().length() - 1));
        return false;
    }

    @Override
    public boolean visit(JpqlNamedInputParameter node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        try {
            data.setResult(data.getNamedParameterValue(node.getValue()));
        }
        catch (NotEvaluatableException e) {
            data.setResultUndefined();
        }
        return false;
    }

    @Override
    public boolean visit(JpqlPositionalInputParameter node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        try {
            data.setResult(data.getPositionalParameterValue(Integer.parseInt(node.getValue())));
        }
        catch (NotEvaluatableException e) {
            data.setResultUndefined();
        }
        return false;
    }

    @Override
    public boolean visit(JpqlEscapeCharacter node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        data.setResult(node.getValue());
        return false;
    }

    @Override
    public boolean visit(JpqlTrimCharacter node, QueryEvaluationParameters data) {
        this.validateChildCount(node, 0);
        data.setResult(node.getValue().substring(1, node.getValue().length() - 1));
        return false;
    }

    @Override
    public boolean visit(JpqlExists node, QueryEvaluationParameters data) {
        try {
            node.jjtGetChild(0).visit(this, data);
            data.setResult(!((Collection)data.getResult()).isEmpty());
        }
        catch (NotEvaluatableException notEvaluatableException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean visit(JpqlSubselect node, QueryEvaluationParameters data) {
        JpqlCompiledStatement subselect = this.compiler.compile(node);
        for (SubselectEvaluator subselectEvaluator : this.subselectEvaluators) {
            try {
                data.setResult(subselectEvaluator.evaluate(subselect, data));
                return false;
            }
            catch (NotEvaluatableException e) {
                data.setResultUndefined();
            }
        }
        return false;
    }

    protected Collection<?> getResultCollection(Object result) {
        if (result == null) {
            return Collections.emptySet();
        }
        if (result instanceof Collection) {
            return (Collection)result;
        }
        return Collections.singleton(result);
    }

    private Object convert(Object object) {
        if (!(object instanceof Number) || object instanceof BigDecimal) {
            return object;
        }
        if (object instanceof Float) {
            return BigDecimal.valueOf(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return BigDecimal.valueOf((Double)object);
        }
        return new BigDecimal(object.toString());
    }
}

