/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.mapping;

import net.sf.jpasecurity.mapping.Alias;

public class Path {
    private Alias rootAlias;
    private String subpath;

    public Path(String path) {
        int index = path.indexOf(46);
        if (index == -1) {
            this.rootAlias = new Alias(path.trim());
            this.subpath = null;
        } else {
            this.rootAlias = new Alias(path.substring(0, index));
            this.subpath = path.substring(index + 1).trim();
        }
    }

    public boolean hasSubpath() {
        return this.subpath != null;
    }

    public Alias getRootAlias() {
        return this.rootAlias;
    }

    public String getSubpath() {
        return this.subpath;
    }

    public String toString() {
        return this.hasSubpath() ? this.rootAlias.getName() + '.' + this.getSubpath() : this.rootAlias.getName();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Path)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }
}

