/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.security.authentication;

import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.sf.jpasecurity.configuration.AuthenticationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthenticationProvider
implements AuthenticationProvider {
    private static ThreadLocal<Object> principal = new ThreadLocal();
    private static ThreadLocal<Collection<?>> roles = new ThreadLocal();

    public void authenticate(Object principal, Object ... roles) {
        this.authenticate(principal, Arrays.asList(roles));
    }

    public void authenticate(Object principal, Collection<?> roles) {
        DefaultAuthenticationProvider.principal.set(principal);
        DefaultAuthenticationProvider.roles.set(roles);
    }

    public void unauthenticate() {
        principal.remove();
        roles.remove();
    }

    @Override
    public Object getPrincipal() {
        return principal.get();
    }

    public Collection<?> getRoles() {
        Collection<?> result = roles.get();
        return result != null ? result : Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R runAs(Object principal, Collection<?> roles, PrivilegedExceptionAction<R> action) throws Exception {
        DefaultAuthenticationProvider authenticationProvider = new DefaultAuthenticationProvider();
        Object currentPrincipal = authenticationProvider.getPrincipal();
        Collection<?> currentRoles = authenticationProvider.getRoles();
        try {
            authenticationProvider.authenticate(principal, roles);
            R r = action.run();
            return r;
        }
        finally {
            authenticationProvider.authenticate(currentPrincipal, currentRoles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R runAs(Object principal, Collection<?> roles, PrivilegedAction<R> action) {
        DefaultAuthenticationProvider authenticationProvider = new DefaultAuthenticationProvider();
        Object currentPrincipal = authenticationProvider.getPrincipal();
        Collection<?> currentRoles = authenticationProvider.getRoles();
        try {
            authenticationProvider.authenticate(principal, roles);
            R r = action.run();
            return r;
        }
        finally {
            authenticationProvider.authenticate(currentPrincipal, currentRoles);
        }
    }
}

