/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.security.rules;

import java.util.HashSet;
import java.util.Set;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.configuration.DefaultExceptionFactory;
import net.sf.jpasecurity.xml.AbstractXmlParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebXmlRolesParser
extends AbstractXmlParser<XmlRolesHandler> {
    public WebXmlRolesParser() {
        this(new DefaultExceptionFactory());
    }

    public WebXmlRolesParser(ExceptionFactory factory) {
        super(new XmlRolesHandler(), factory);
    }

    public Set<String> getRoles() {
        return ((XmlRolesHandler)this.getHandler()).getRoles();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class XmlRolesHandler
    extends DefaultHandler {
        private static final String ROLE_NAME_TAG = "role-name";
        private StringBuilder currentText = new StringBuilder();
        private Set<String> roles = new HashSet<String>();

        protected XmlRolesHandler() {
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        @Override
        public void startElement(String uri, String tag, String qualified, Attributes attributes) throws SAXException {
            if (ROLE_NAME_TAG.equals(qualified)) {
                this.currentText.setLength(0);
            }
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            this.currentText.append(chars, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
            String text = this.currentText.toString().trim();
            this.currentText.setLength(0);
            if (ROLE_NAME_TAG.equals(qualifiedName)) {
                this.roles.add(text);
            }
        }
    }
}

