/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.security.rules;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.security.rules.AbstractAccessRulesProvider;
import net.sf.jpasecurity.util.ListHashMap;
import net.sf.jpasecurity.util.ListMap;
import net.sf.jpasecurity.xml.AbstractXmlParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlAccessRulesProvider
extends AbstractAccessRulesProvider {
    protected void initializeAccessRules() {
        String persistenceUnitName = this.getPersistenceMapping().getSecurityUnitName();
        ExceptionFactory exceptionFactory = this.getConfiguration().getExceptionFactory();
        RulesParser parser = new RulesParser(persistenceUnitName, exceptionFactory);
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources("META-INF/security.xml");
            while (urls.hasMoreElements()) {
                parser.parse(urls.nextElement());
            }
        }
        catch (IOException e) {
            throw this.getConfiguration().getExceptionFactory().createRuntimeException(e);
        }
        this.compileRules(parser.getAccessRules());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RulesParser
    extends AbstractXmlParser<RulesHandler> {
        private String persistenceUnitName;

        public RulesParser(String persistenceUnitName, ExceptionFactory exceptionFactory) {
            super(new RulesHandler(), exceptionFactory);
            this.persistenceUnitName = persistenceUnitName;
        }

        public List<String> getAccessRules() {
            return ((RulesHandler)this.getHandler()).getAccessRules(this.persistenceUnitName);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class RulesHandler
        extends DefaultHandler {
            private static final String PERSISTENCE_UNIT_TAG = "persistence-unit";
            private static final String PERSISTENCE_UNIT_NAME_ATTRIBUTE = "name";
            private static final String ACCESS_RULE_TAG = "access-rule";
            private ListMap<String, String> accessRules = new ListHashMap<String, String>();
            private String persistenceUnit;
            private StringBuilder accessRule = new StringBuilder();

            private RulesHandler() {
            }

            public List<String> getAccessRules(String persistenceUnit) {
                return (List)this.accessRules.getNotNull(persistenceUnit);
            }

            @Override
            public void startElement(String uri, String tag, String qualified, Attributes attributes) throws SAXException {
                if (PERSISTENCE_UNIT_TAG.equals(qualified)) {
                    this.persistenceUnit = attributes.getValue(PERSISTENCE_UNIT_NAME_ATTRIBUTE);
                } else if (ACCESS_RULE_TAG.equals(qualified)) {
                    this.accessRule.setLength(0);
                }
            }

            @Override
            public void characters(char[] chars, int start, int length) throws SAXException {
                this.accessRule.append(chars, start, length);
            }

            @Override
            public void endElement(String uri, String tag, String qualified) throws SAXException {
                if (ACCESS_RULE_TAG.equals(qualified)) {
                    this.accessRules.add(this.persistenceUnit, this.accessRule.toString());
                }
            }
        }
    }
}

