/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.bean;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlType;


/**
 * 一括制御のコマンド情報を保持するクラスです。<BR>
 * 一括制御[作成・変更]ダイアログから設定します。
 * 
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
@XmlType(namespace = "http://collectiverun.ws.clustercontrol.com")
public class CommandInfo extends ItemInfo {
	private static final long serialVersionUID = -7480505938284610080L;

	/** コマンドID */
	private String id;

	/** コマンド種別 */
	private Integer commandType = new Integer(0);

	/** コマンド */
	private String command;

	/** コマンド種別ID */
	private String commandTypeId;

	/** 終了状態 */
	private List<EndStatusInfo> endStatus;

	/**
	 * @return
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return
	 */
	public String getCommand() {
		return command;
	}

	/**
	 * @param command
	 */
	public void setCommand(String command) {
		this.command = command;
	}

	/**
	 * @return
	 */
	public Integer getCommandType() {
		return commandType;
	}

	/**
	 * @param commandType
	 */
	public void setCommandType(Integer commandType) {
		this.commandType = commandType;
	}

	/**
	 * @return
	 */
	public String getCommandTypeId() {
		return commandTypeId;
	}

	/**
	 * @param command
	 */
	public void setCommandTypeId(String commandTypeId) {
		this.commandTypeId = commandTypeId;
	}

	/**
	 * @return
	 */
	public List<EndStatusInfo> getEndStatus() {
		return endStatus;
	}

	/**
	 * @param endStatus
	 */
	public void setEndStatus(List<EndStatusInfo> endStatus) {
		this.endStatus = endStatus;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 * @since 2.1.0
	 */
	@Override
	public Object clone() {
		CommandInfo clone = (CommandInfo)super.clone();

		clone.setId(this.getId());
		clone.setCommandType(this.getCommandType());
		clone.setCommand(this.getCommand());

		ArrayList<EndStatusInfo> cloneList = new ArrayList<EndStatusInfo>();
		if(this.getEndStatus() != null && this.getEndStatus() instanceof ArrayList){
			for(int i = 0; i < this.getEndStatus().size(); i++){
				Object source = this.getEndStatus().get(i);
				if(source != null && source instanceof EndStatusInfo){
					cloneList.add((EndStatusInfo)((EndStatusInfo)source).clone());
				}
			}
		}
		clone.setEndStatus(cloneList);

		return clone;
	}
}