/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.util;

import java.util.HashMap;
import java.util.Map;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * JPA用のConfig
 */
public class JpaPersistenceConfig {

	private static Log m_log = LogFactory.getLog(JpaPersistenceConfig.class);

	/** JPAのプロパティ名 */
	public static final String JPA_PARAM_QUERY_TIMEOUT = "javax.persistence.query.timeout";

	/** 重複チェック（EntityExistsExceptionチェック）で使用するヒント */
	public static final Map<String, Object> JPA_EXISTS_CHECK_HINT_MAP = new HashMap<String, Object>();

	/** EntityManagerFactory */
	private static EntityManagerFactory hinemosEMFactory = null;

	static {
		JPA_EXISTS_CHECK_HINT_MAP.put("javax.persistence.cache.storeMode","REFRESH");
	}
	/*
	 * Hinemos用のEntityManagerFactoryを返す
	 */
	public static EntityManagerFactory getHinemosEMFactory() {
		if (hinemosEMFactory == null
				|| !hinemosEMFactory.isOpen()) {
			hinemosEMFactory = Persistence.createEntityManagerFactory("hinemos");
		}
		return hinemosEMFactory;
	}

}
