/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.factory;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.persistence.EntityManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.monitor.bean.StatusExpirationConstant;
import com.clustercontrol.notify.monitor.util.QueryUtil;
import com.clustercontrol.notify.monitor.model.StatusInfoEntity;
import com.clustercontrol.util.Messages;

/**
 * ステータス情報を管理するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.0.0
 */
public class ManageStatus {

	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( ManageStatus.class );

	/**
	 * 存続期間を経過したステータス情報を削除 または 更新します。
	 * <p>
	 * <ol>
	 *  <li>存続期間を経過したステータス情報を取得します。
	 *  <li>取得したステータス情報の存続期間経過後の処理の制御フラグを確認します。
	 *  <li>制御フラグ（{@link com.clustercontrol.bean.StatusExpirationConstant}）が削除の場合は、ステータス情報を削除します。<BR>
	 *      重要度の場合は、ステータス情報を更新します。更新する項目は、下記の通りです。
	 *      <ul>
	 *       <li>重要度
	 *       <li>メッセージID（空白）
	 *       <li>メッセージ
	 *       <li>最終変更日時
	 *       <li>存続期間経過後の処理の制御フラグ（期限切れ）
	 *      </ul>
	 * </ol>
	 * 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public void execute(){
		EntityManager em = new JpaTransactionManager().getEntityManager();

		// 有効期限切れのステータス情報一覧を取得
		List<StatusInfoEntity> ct = QueryUtil.getStatusInfoByExpirationStatus(new Timestamp(new Date().getTime()));
		Timestamp now = new Timestamp(new Date().getTime());

		Iterator<StatusInfoEntity> itr = ct.iterator();
		StatusInfoEntity status = null;
		while(itr.hasNext())
		{
			status = itr.next();
			if(status.getExpirationFlg() != null){
				int flg = status.getExpirationFlg().intValue();

				// 削除
				if(StatusExpirationConstant.TYPE_DELETE == flg){
					em.remove(status);
				}
				// 更新されていない旨のメッセージに置換える
				else if(StatusExpirationConstant.TYPE_CRITICAL == flg ||
						StatusExpirationConstant.TYPE_WARNING == flg ||
						StatusExpirationConstant.TYPE_INFO == flg ||
						StatusExpirationConstant.TYPE_UNKNOWN == flg){
					// メッセージIDを空白にする
					status.setMessageId("");
					// 重要度の設定
					status.setPriority(new Integer(flg));
					// メッセージに更新されていない旨のメッセージを設定
					status.setMessage(Messages.getString("monitor.status.no.update"));
					// 有効期限切れ制御フラグに有効期限切れを設定
					status.setExpirationFlg(StatusExpirationConstant.TYPE_EXPIRATION);
					// 更新日時を設定
					status.setOutputDate(now);
				}
			}
		}
	}
}