/*

 Copyright (C) 2009 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.bean;

import javax.xml.bind.annotation.XmlType;

/**
 * 通知コマンド情報を保持するクラスです。
 */
@XmlType(namespace = "http://notify.ws.clustercontrol.com")
public class NotifyCommandInfo  extends NotifyInfoDetail
{
	private static final long serialVersionUID = 5947279803743475747L;

	/**実行コマンド*/
	private String  m_command;

	/**実効ユーザ*/
	private String m_effectiveUser;

	/**コマンド実行時に環境変数を読み込むか否かのフラグ*/
	private Integer m_setEnvironment;

	/**コマンド実行のタイムアウト値*/
	private Long m_timeout;

	/**
	 * コンストラクタ。
	 */
	public NotifyCommandInfo(){

	}

	/**
	 * コンストラクタ。
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 */
	public NotifyCommandInfo(
			String notifyId,
			Integer priority,
			Integer vaildFlg,
			String command,
			String effectiveUser,
			Integer setEnvironment,
			Long timeout) {

		setNotifyId(notifyId);
		setPriority(priority);
		setValidFlg(vaildFlg);
		setCommand(command);
		setEffectiveUser(effectiveUser);
		setSetEnvironment(setEnvironment);
		setTimeout(timeout);
	}

	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の通知情報
	 */
	public NotifyCommandInfo( NotifyCommandInfo otherData ) {
		setNotifyId(otherData.getNotifyId());
		setPriority(otherData.getPriority());
		setValidFlg(otherData.getValidFlg());
		setCommand(otherData.getCommand());
		setEffectiveUser(otherData.getEffectiveUser());
		setSetEnvironment(otherData.getSetEnvironment());
		setTimeout(otherData.getTimeout());
	}

	public String getCommand() {
		return m_command;
	}


	public void setCommand(String command) {
		this.m_command = command;
	}


	public String getEffectiveUser() {
		return m_effectiveUser;
	}


	public void setEffectiveUser(String effectiveUser) {
		this.m_effectiveUser = effectiveUser;
	}


	public Integer getSetEnvironment() {
		return m_setEnvironment;
	}


	public void setSetEnvironment(Integer setEnvironment) {
		this.m_setEnvironment = setEnvironment;
	}


	public Long getTimeout() {
		return m_timeout;
	}


	public void setTimeout(Long timeout) {
		this.m_timeout = timeout;
	}
}
