/*

Copyright (C) 2007 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.ping.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * プロセス監視プロパティ情報取得クラス
 *
 * @version 2.3.0 bata
 * @since 2.3.0
 * @author Yosuke Miyamoto
 */
public class PingProperties {
	private static Log m_log = LogFactory.getLog( PingProperties.class );

	private static final String FPING_ENABLE="true";
	private static final String FPING_COUNT= "1";
	private static final String FPING_INTERVAL= "1000";
	private static final String FPING_TIMEOUT="1000";
	private static final String FPING_BYTES="56";
	private static final String FPING_PATH="/opt/hinemos/sbin/fping";
	private static final String FPING6_PATH="/opt/hinemos/sbin/fping6";

	private static final String FPING_ENABLE_KEY = "monitor.ping.fping.enable";
	private static final String FPING_COUNT_KEY = "monitor.ping.fping.count";
	private static final String FPING_INTERVAL_KEY="monitor.ping.fping.interval";
	private static final String FPING_TIMEOUT_KEY="monitor.ping.fping.timeout";
	private static final String FPING_BYTES_KEY="monitor.ping.fping.bytes";
	private static final String FPING_PATH_KEY="monitor.ping.fping.path";
	private static final String FPING6_PATH_KEY="monitor.ping.fping6.path";

	private static PingProperties m_instance = null;

	/** Fpingを使用するか？　falseであれば2.2までのisReachableを利用 */
	private static boolean m_fpingEnable;
	/** fping利用時のデフォルトの　ping回数 */
	private static int m_fpingCount;
	/** fping利用時のデフォルトの　pingインターバル msec*/
	private static int m_fpingInterval;
	/** fping利用時のデフォルトの　pingタイムアウト msec*/
	private static int m_fpingTimeout;
	/** fping利用時のデフォルトの　ping送信データサイズ byte*/
	private static int m_fpingBytes;

	/** fping のパス **/
	private static String m_fpingPath;
	private static String m_fping6Path;

	/**
	 * このオブジェクトを取得します。
	 * 
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @return ConnectionManager コネクションマネージャ
	 */
	public static PingProperties getProperties() {
		if (m_instance==null) {
			m_instance = new PingProperties();
		}
		return m_instance;
	}

	/**
	 * コンストラクタ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	private PingProperties() {
		this.setValue();
	}

	/**m_fpingEnable
	 * プロセス監視情報をプロパティファイルから取得
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	private void setValue() {

		Properties properties = new Properties();

		try {
			String etcdir = System.getProperty("hinemos.manager.etc.dir");
			String propertyFile = etcdir + File.separator + "hinemos.properties";

			// プロパティファイルからキーと値のリストを読み込みます
			properties.load(new FileInputStream(propertyFile));

			String enable= properties.getProperty(FPING_ENABLE_KEY, FPING_ENABLE);
			String count = properties.getProperty(FPING_COUNT_KEY, FPING_COUNT);
			String interval = properties.getProperty(FPING_INTERVAL_KEY,FPING_INTERVAL);
			String timeout = properties.getProperty(FPING_TIMEOUT_KEY,FPING_TIMEOUT);
			String bytes = properties.getProperty(FPING_BYTES_KEY,FPING_BYTES);
			m_fpingPath =  properties.getProperty(FPING_PATH_KEY,FPING_PATH);
			m_fping6Path =  properties.getProperty(FPING6_PATH_KEY,FPING6_PATH);

			m_fpingEnable = new Boolean(enable).booleanValue();
			m_fpingCount = new Integer(count).intValue();
			m_fpingInterval = new Integer(interval).intValue();
			m_fpingTimeout = new Integer(timeout).intValue();
			m_fpingBytes = new Integer(bytes).intValue();

		} catch (Exception e) {
			m_log.warn("setValue() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage(), e);
		}
	}

	protected static int getFpingCount() {
		return m_fpingCount;
	}

	public static boolean isFpingEnable() {
		return m_fpingEnable;
	}

	protected static int getFpingInterval() {
		return m_fpingInterval;
	}

	protected static int getFpingTimeout() {
		return m_fpingTimeout;
	}

	protected static int getFpingBytes() {
		return m_fpingBytes;
	}

	protected static String getFpingPath() {
		return m_fpingPath;
	}

	protected static String getFping6Path() {
		return m_fping6Path;
	}

}
