package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;


/**
 * The persistent class for the cc_crun_end_mst database table.
 * 
 */
@Entity
@Table(name="cc_crun_end_mst")
@Cacheable(true)
public class CrunEndMstEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private CrunEndMstEntityPK id;
	private Integer endValueFrom;
	private Integer endValueTo;
	private CrunCmdMstEntity crunCmdMstEntity;

	@Deprecated
	public CrunEndMstEntity() {
	}

	public CrunEndMstEntity(CrunEndMstEntityPK pk,
			CrunCmdMstEntity crunCmdMstEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToCrunCmdMstEntity(crunCmdMstEntity);
	}

	public CrunEndMstEntity(String commandId, Integer endStatus,
			CrunCmdMstEntity crunCmdMstEntity) {
		this(new CrunEndMstEntityPK(commandId, endStatus), crunCmdMstEntity);
	}

	@EmbeddedId
	public CrunEndMstEntityPK getId() {
		return this.id;
	}

	public void setId(CrunEndMstEntityPK id) {
		this.id = id;
	}


	@Column(name="end_value_from")
	public Integer getEndValueFrom() {
		return this.endValueFrom;
	}

	public void setEndValueFrom(Integer endValueFrom) {
		this.endValueFrom = endValueFrom;
	}


	@Column(name="end_value_to")
	public Integer getEndValueTo() {
		return this.endValueTo;
	}

	public void setEndValueTo(Integer endValueTo) {
		this.endValueTo = endValueTo;
	}


	//bi-directional many-to-one association to CrunCmdMstEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="command_id", insertable=false, updatable=false)
	public CrunCmdMstEntity getCrunCmdMstEntity() {
		return this.crunCmdMstEntity;
	}

	@Deprecated
	public void setCrunCmdMstEntity(CrunCmdMstEntity crunCmdMstEntity) {
		this.crunCmdMstEntity = crunCmdMstEntity;
	}

	/**
	 * CrunCmdMstEntityオブジェクト参照設定<BR>
	 * 
	 * CrunCmdMstEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToCrunCmdMstEntity(CrunCmdMstEntity crunCmdMstEntity) {
		this.setCrunCmdMstEntity(crunCmdMstEntity);
		if (crunCmdMstEntity != null) {
			List<CrunEndMstEntity> list = crunCmdMstEntity.getCrunEndMstEntities();
			if (list == null) {
				list = new ArrayList<CrunEndMstEntity>();
			} else {
				for(CrunEndMstEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			crunCmdMstEntity.setCrunEndMstEntities(list);
		}
	}


	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// CrunCmdMstEntity
		if (this.crunCmdMstEntity != null) {
			List<CrunEndMstEntity> list = this.crunCmdMstEntity.getCrunEndMstEntities();
			if (list != null) {
				Iterator<CrunEndMstEntity> iter = list.iterator();
				while(iter.hasNext()) {
					CrunEndMstEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}