package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import java.util.Arrays;

import javax.persistence.*;

/**
 * The primary key class for the cc_crun_param_select_mst database table.
 * 
 */
@Embeddable
public class CrunParamSelectMstEntityPK implements Serializable {
	//default serial version id, required for serializable classes.
	private static final long serialVersionUID = 1L;
	private String paramId;
	private Integer orderNo;

	public CrunParamSelectMstEntityPK() {
	}

	public CrunParamSelectMstEntityPK(String paramId, Integer orderNo) {
		this.setParamId(paramId);
		this.setOrderNo(orderNo);
	}

	@Column(name="param_id")
	public String getParamId() {
		return this.paramId;
	}
	public void setParamId(String paramId) {
		this.paramId = paramId;
	}

	@Column(name="order_no")
	public Integer getOrderNo() {
		return this.orderNo;
	}
	public void setOrderNo(Integer orderNo) {
		this.orderNo = orderNo;
	}

	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof CrunParamSelectMstEntityPK)) {
			return false;
		}
		CrunParamSelectMstEntityPK castOther = (CrunParamSelectMstEntityPK)other;
		return
				this.paramId.equals(castOther.paramId)
				&& this.orderNo.equals(castOther.orderNo);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int hash = 17;
		hash = hash * prime + this.paramId.hashCode();
		hash = hash * prime + this.orderNo.hashCode();

		return hash;
	}

	@Override
	public String toString() {
		String[] names = {
				"paramId",
				"orderNo"
		};
		String[] values = {
				this.paramId,
				this.orderNo.toString()
		};
		return Arrays.toString(names) + " = " + Arrays.toString(values);
	}
}