package com.clustercontrol.notify.model;

import java.io.Serializable;
import javax.persistence.*;

import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.commons.util.JpaTransactionManager;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


/**
 * The persistent class for the cc_notify_history database table.
 * 
 */
@Entity
@Table(name="cc_notify_history")
@Cacheable(true)
public class NotifyHistoryEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private NotifyHistoryEntityPK id;
	private Timestamp lastNotify;
	private Integer priority;

	@Deprecated
	public NotifyHistoryEntity() {
	}

	public NotifyHistoryEntity(NotifyHistoryEntityPK pk,
			NotifyInfoEntity notifyInfoEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
	}

	public NotifyHistoryEntity(NotifyInfoEntity notifyInfoEntity,
			String facilityId,
			String pluginId,
			String monitorId,
			String subKey) {
		this(new NotifyHistoryEntityPK(facilityId,
				pluginId,
				monitorId,
				notifyInfoEntity.getNotifyId(),
				subKey), notifyInfoEntity);
	}

	@EmbeddedId
	public NotifyHistoryEntityPK getId() {
		return this.id;
	}

	public void setId(NotifyHistoryEntityPK id) {
		this.id = id;
	}


	@Column(name="last_notify")
	public Timestamp getLastNotify() {
		return this.lastNotify;
	}

	public void setLastNotify(Timestamp lastNotify) {
		this.lastNotify = lastNotify;
	}


	public Integer getPriority() {
		return this.priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}

}