package com.clustercontrol.notify.model;

import java.io.Serializable;
import java.util.Arrays;

import javax.persistence.*;

/**
 * The primary key class for the cc_notify_mail_info database table.
 * 
 */
@Embeddable
public class NotifyMailInfoEntityPK implements Serializable {
	//default serial version id, required for serializable classes.
	private static final long serialVersionUID = 1L;
	private String notifyId;
	private Integer priority;

	public NotifyMailInfoEntityPK() {
	}

	public NotifyMailInfoEntityPK(String notifyId, Integer priority) {
		this.setNotifyId(notifyId);
		this.setPriority(priority);
	}

	@Column(name="notify_id")
	public String getNotifyId() {
		return this.notifyId;
	}
	public void setNotifyId(String notifyId) {
		this.notifyId = notifyId;
	}

	public Integer getPriority() {
		return this.priority;
	}
	public void setPriority(Integer priority) {
		this.priority = priority;
	}

	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof NotifyMailInfoEntityPK)) {
			return false;
		}
		NotifyMailInfoEntityPK castOther = (NotifyMailInfoEntityPK)other;
		return
				this.notifyId.equals(castOther.notifyId)
				&& this.priority.equals(castOther.priority);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int hash = 17;
		hash = hash * prime + this.notifyId.hashCode();
		hash = hash * prime + this.priority.hashCode();

		return hash;
	}

	@Override
	public String toString() {
		String[] names = {
				"notifyId",
				"priority"
		};
		String[] values = {
				this.notifyId,
				this.priority.toString()
		};
		return Arrays.toString(names) + " = " + Arrays.toString(values);
	}
}