package com.clustercontrol.notify.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;


/**
 * The persistent class for the cc_notify_status_info database table.
 * 
 */
@Entity
@Table(name="cc_notify_status_info")
@Cacheable(true)
public class NotifyStatusInfoEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private NotifyStatusInfoEntityPK id;
	private Integer statusFlg;
	private Integer statusInvalidFlg;
	private Integer statusUpdatePriority;
	private Integer statusValidPeriod;
	private NotifyInfoEntity notifyInfoEntity;

	@Deprecated
	public NotifyStatusInfoEntity() {
	}

	public NotifyStatusInfoEntity(NotifyStatusInfoEntityPK pk,
			NotifyInfoEntity notifyInfoEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToNotifyInfoEntity(notifyInfoEntity);
	}

	public NotifyStatusInfoEntity(String notifyId, Integer priority,
			NotifyInfoEntity notifyInfoEntity) {
		this(new NotifyStatusInfoEntityPK(notifyId, priority), notifyInfoEntity);
	}


	@EmbeddedId
	public NotifyStatusInfoEntityPK getId() {
		return this.id;
	}

	public void setId(NotifyStatusInfoEntityPK id) {
		this.id = id;
	}


	@Column(name="status_flg")
	public Integer getStatusFlg() {
		return this.statusFlg;
	}

	public void setStatusFlg(Integer statusFlg) {
		this.statusFlg = statusFlg;
	}


	@Column(name="status_invalid_flg")
	public Integer getStatusInvalidFlg() {
		return this.statusInvalidFlg;
	}

	public void setStatusInvalidFlg(Integer statusInvalidFlg) {
		this.statusInvalidFlg = statusInvalidFlg;
	}


	@Column(name="status_update_priority")
	public Integer getStatusUpdatePriority() {
		return this.statusUpdatePriority;
	}

	public void setStatusUpdatePriority(Integer statusUpdatePriority) {
		this.statusUpdatePriority = statusUpdatePriority;
	}


	@Column(name="status_valid_period")
	public Integer getStatusValidPeriod() {
		return this.statusValidPeriod;
	}

	public void setStatusValidPeriod(Integer statusValidPeriod) {
		this.statusValidPeriod = statusValidPeriod;
	}


	//bi-directional many-to-one association to NotifyInfoEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="notify_id", insertable=false, updatable=false)
	public NotifyInfoEntity getNotifyInfoEntity() {
		return this.notifyInfoEntity;
	}

	@Deprecated
	public void setNotifyInfoEntity(NotifyInfoEntity notifyInfoEntity) {
		this.notifyInfoEntity = notifyInfoEntity;
	}

	/**
	 * NotifyInfoEntityオブジェクト参照設定<BR>
	 * 
	 * NotifyInfoEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToNotifyInfoEntity(NotifyInfoEntity notifyInfoEntity) {
		this.setNotifyInfoEntity(notifyInfoEntity);
		if (notifyInfoEntity != null) {
			List<NotifyStatusInfoEntity> list = notifyInfoEntity.getNotifyStatusInfoEntities();
			if (list == null) {
				list = new ArrayList<NotifyStatusInfoEntity>();
			} else {
				for(NotifyStatusInfoEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			notifyInfoEntity.setNotifyStatusInfoEntities(list);
		}
	}

	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// NotifyInfoEntity
		if (this.notifyInfoEntity != null) {
			List<NotifyStatusInfoEntity> list = this.notifyInfoEntity.getNotifyStatusInfoEntities();
			if (list != null) {
				Iterator<NotifyStatusInfoEntity> iter = list.iterator();
				while(iter.hasNext()) {
					NotifyStatusInfoEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}