package com.clustercontrol.snmptrap.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;


/**
 * The persistent class for the cc_snmp_trap_mst database table.
 * 
 */
@Entity
@Table(name="cc_snmp_trap_mst")
@Cacheable(true)
public class SnmpTrapMstEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private SnmpTrapMstEntityPK id;
	private String descr;
	private String logmsg;
	private Integer priority;
	private String uei;
	private SnmpTrapMibMstEntity snmpTrapMibMstEntity;

	@Deprecated
	public SnmpTrapMstEntity() {
	}

	public SnmpTrapMstEntity(SnmpTrapMstEntityPK pk,
			SnmpTrapMibMstEntity snmpTrapMibMstEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToSnmpTrapMibMstEntity(snmpTrapMibMstEntity);
	}

	public SnmpTrapMstEntity(String mib,
			String trapOid,
			Integer genericId,
			Integer specificId,
			SnmpTrapMibMstEntity snmpTrapMibMstEntity) {
		this(new SnmpTrapMstEntityPK(mib, trapOid, genericId, specificId), snmpTrapMibMstEntity);
	}

	@EmbeddedId
	public SnmpTrapMstEntityPK getId() {
		return this.id;
	}

	public void setId(SnmpTrapMstEntityPK id) {
		this.id = id;
	}


	public String getDescr() {
		return this.descr;
	}

	public void setDescr(String descr) {
		this.descr = descr;
	}


	public String getLogmsg() {
		return this.logmsg;
	}

	public void setLogmsg(String logmsg) {
		this.logmsg = logmsg;
	}


	public Integer getPriority() {
		return this.priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}


	public String getUei() {
		return this.uei;
	}

	public void setUei(String uei) {
		this.uei = uei;
	}


	//bi-directional many-to-one association to SnmpTrapMibMstEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="mib", insertable=false, updatable=false)
	public SnmpTrapMibMstEntity getSnmpTrapMibMstEntity() {
		return this.snmpTrapMibMstEntity;
	}

	@Deprecated
	public void setSnmpTrapMibMstEntity(SnmpTrapMibMstEntity snmpTrapMibMstEntity) {
		this.snmpTrapMibMstEntity = snmpTrapMibMstEntity;
	}

	/**
	 * SnmpTrapMibMstEntityオブジェクト参照設定<BR>
	 * 
	 * SnmpTrapMibMstEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToSnmpTrapMibMstEntity(SnmpTrapMibMstEntity snmpTrapMibMstEntity) {
		this.setSnmpTrapMibMstEntity(snmpTrapMibMstEntity);
		if (snmpTrapMibMstEntity != null) {
			List<SnmpTrapMstEntity> list = snmpTrapMibMstEntity.getSnmpTrapMstEntities();
			if (list == null) {
				list = new ArrayList<SnmpTrapMstEntity>();
			} else {
				for(SnmpTrapMstEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			snmpTrapMibMstEntity.setSnmpTrapMstEntities(list);
		}
	}

	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// SnmpTrapMibMstEntity
		if (this.snmpTrapMibMstEntity != null) {
			List<SnmpTrapMstEntity> list = this.snmpTrapMibMstEntity.getSnmpTrapMstEntities();
			if (list != null) {
				Iterator<SnmpTrapMstEntity> iter = list.iterator();
				while(iter.hasNext()) {
					SnmpTrapMstEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}