/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

import com.clustercontrol.ws.managercli.ManagerCliEndpointService;

public class EndpointManager {

	private static final Logger logger = Logger.getLogger(EndpointManager.class.getSimpleName());

	private static EndpointList endpointList;
	private final static String MANAGEMENT = ManagerCliEndpointService.class.getSimpleName();

	private static class EndpointList {

		private List<Map<String, EndpointSetting>> endpointList = new ArrayList<Map<String,EndpointSetting>>();
		private Map<String, EndpointSetting> lastSuccessEndpoint = null;

		private void add(Map<String, EndpointSetting> endpointMap) {
			if (lastSuccessEndpoint == null) {
				lastSuccessEndpoint = endpointMap;
			}
			endpointList.add(endpointMap);
		}

		private List<EndpointSetting> getList(String key) {
			List<EndpointSetting> list = new ArrayList<EndpointSetting>();
			list.add(lastSuccessEndpoint.get(key));
			for (Map<String, EndpointSetting> endpoint : endpointList) {
				if (!endpoint.equals(lastSuccessEndpoint)) {
					list.add(endpoint.get(key));
				}
			}
			return list;
		}

		/*
		 * 当面、使用予定なし。
		 */
		@SuppressWarnings("unused")
		@Deprecated
		private void setLastSuccess(Map<String, EndpointSetting> endpoint) {
			if (!endpointList.contains(endpoint)) {
				logger.warning("setLastSuccess(), Error:!endpointList.contains(endpoint)");
			}
			lastSuccessEndpoint = endpoint;
			if (logger.isLoggable(Level.FINER))
				logger.finer("set lastSuccessEndpoint. new one is " + lastSuccessEndpoint);
		}

		/**
		 * リストの順番を変えるメソッド。
		 * endpointListの順番で、lastSuccesEndpointをローテートする。
		 * @param endpoint
		 */
		private void changeEndpoint() {
			if (logger.isLoggable(Level.FINER)) logger.finer("changeEndpoint");

			boolean flag = false;
			for (Map<String, EndpointSetting> e : endpointList) {
				if (flag) {
					lastSuccessEndpoint = e;
					flag = false;
					return;
				}
				if (lastSuccessEndpoint.equals(e)) {
					flag = true;
				}
			}
			lastSuccessEndpoint = endpointList.get(0);
		}

		/**
		 * ログアウト
		 */
		private void logout() {
			for (Map<String, EndpointSetting> map : endpointList) {
				for (String key : map.keySet()) {
					EndpointSetting setting = map.get(key);
					setting.logout();
				}
			}
		}

		private int size() {
			return endpointList.size();
		}
	}

	public static class EndpointSetting {
		private String key;
		private String urlPrefix;
		private Object endpoint;
		private String wsdlSuffix = "?wsdl";

		private EndpointSetting(String key, String urlPrefix) {
			this.key = key;
			this.urlPrefix = urlPrefix;
		}

		private void logout() {
			endpoint = null;
		}

		public Object getEndpoint()  {
			if (endpoint != null) {
				return endpoint;
			}

			String tmpKey = null;
			tmpKey = MANAGEMENT;
			if (tmpKey.equals(key)) {
				String urlStr = urlPrefix + tmpKey + wsdlSuffix;
				ManagerCliEndpointService tmpEndpointService = null;
				try {
					tmpEndpointService = new ManagerCliEndpointService(
							new URL(urlStr),
							new QName("http://managercli.ws.clustercontrol.com", tmpKey));
				} catch (MalformedURLException e) {
					logger.warning("genEndpoint() : ManagementEndpointService, " + e.getMessage());
				}
				endpoint = tmpEndpointService.getManagerCliEndpointPort();
				setBindingProvider(endpoint, username, password, urlStr);
			}
			return endpoint;
		}
	}

	private static String username = "";
	private static String password = "";
	private static int m_httpConnectTimeout = HinemosManagerCli.DEFAULT_CONNECT_TIMEOUT;
	private static int m_httpRequestTimeout = HinemosManagerCli.DEFAULT_REQUEST_TIMEOUT;

	public static void init(String user, String pass, String managerAddressList,
			int httpConnectTimeout, int httpRequestTimeout) throws MalformedURLException {
		username = user;
		password = pass;
		endpointList = new EndpointList();
		m_httpConnectTimeout = httpConnectTimeout;
		m_httpRequestTimeout = httpRequestTimeout;

		for (String managerAddress : managerAddressList.split(",")) {
			HashMap<String, EndpointSetting> map = new HashMap<String, EndpointSetting>();
			String wsdlPrefix = managerAddress.trim();

			map.put(MANAGEMENT, new EndpointSetting(MANAGEMENT, wsdlPrefix));

			endpointList.add(map);
		}
		logger.fine("manager instance = " + endpointList.size());
	}

	private static void setBindingProvider(Object o, String user, String password, String urlStr) {
		BindingProvider bp = (BindingProvider)o;
		bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, urlStr);
		bp.getRequestContext().put(BindingProvider.USERNAME_PROPERTY, user);
		bp.getRequestContext().put(BindingProvider.PASSWORD_PROPERTY, password);

		if (logger.isLoggable(Level.FINER))
			logger.finer("connect.timeout = " + m_httpConnectTimeout+ ", request.timeout = " + m_httpRequestTimeout);

		bp.getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", m_httpConnectTimeout * 1000);
		bp.getRequestContext().put("com.sun.xml.internal.ws.request.timeout", m_httpRequestTimeout * 1000);
	}

	/**
	 *  使用可能な順番でManagementEndpointを返す。
	 * @return
	 */
	public static List<EndpointSetting> getManagementEndpoint() {
		return endpointList.getList(MANAGEMENT);
	}

	/**
	 *  Endpointの利用時にWebServiceExceptionが出たらこのメソッドを呼ぶこと。
	 */
	public static void changeEndpoint() {
		endpointList.changeEndpoint();
	}

	/**
	 * ログアウト
	 */
	public static void logout() {
		if (logger.isLoggable(Level.FINER)) logger.finer("logout");
		username = null;
		password = null;
		if (endpointList == null) {
			return;
		}
		endpointList.logout();
	}
}
