/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol;

import java.util.Arrays;
import java.util.logging.Logger;

import javax.xml.ws.WebServiceException;

import com.clustercontrol.EndpointManager.EndpointSetting;
import com.clustercontrol.ws.managercli.HinemosUnknown_Exception;
import com.clustercontrol.ws.managercli.InvalidRole_Exception;
import com.clustercontrol.ws.managercli.InvalidUserPass_Exception;
import com.clustercontrol.ws.managercli.ManagerCliEndpoint;

/**
 * Hinemosマネージャ(ManagementEndpoint)との通信するクラス。
 * @author takahatat
 *
 */
public class ManagerCliEndpointWrapper {

	private static Logger logger = Logger.getLogger(ManagerCliEndpointWrapper.class.getSimpleName());

	public static String invoke(String className, String methodName, String[] args) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;

		// MAIN
		for (EndpointSetting endpointSetting : EndpointManager.getManagementEndpoint()) {
			try {
				ManagerCliEndpoint endpoint = (ManagerCliEndpoint)endpointSetting.getEndpoint();
				return endpoint.invoke(className, methodName, Arrays.asList(args));
			} catch (WebServiceException e) {
				wse = e;
				logger.info("communication failure to manager... : " + e.getMessage());
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

}
