#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../hinemos.cfg
. ${SCRIPT_DIR}/../sbin/hinemos_utility.sh

export PROG=`basename $0`
DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

########################################
#  Local Variable
########################################


########################################
#  Local Message
########################################

# INFO
#MSG_I001="xxx"

# WARN
#MSG_W001="xxx"

# ERROR
#MSG_E001="xxx"

########################################
# Function
########################################

#
# show usage
#
function usage {
	echo "usage : ${PROG} (no argument)"
}

########################################
# SHELL
########################################

# check argument
for OPT in $@
do
	case ${OPT} in
		--help)
			usage
			exit 0
			;;
	esac
done

if [ ! $# = 0 ]
then
	ExitIllegalArgumentError
fi

# main
CheckHinemosManagerStatus
exit $?
